/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.gui.msaa.properties.methods;

import com.ibm.icu.text.MessageFormat;
import org.eclipse.actf.accservice.swtbridge.IA2;
import org.eclipse.actf.visualization.gui.internal.util.Messages;
import org.eclipse.actf.visualization.gui.msaa.properties.fields.AbstractInputField;
import org.eclipse.actf.visualization.gui.msaa.properties.fields.IA2CoordTypeField;
import org.eclipse.actf.visualization.gui.msaa.properties.fields.IA2ScrollTypeField;
import org.eclipse.actf.visualization.gui.msaa.properties.fields.IA2TextBoundaryTypeField;
import org.eclipse.actf.visualization.gui.msaa.properties.fields.IntegerField;
import org.eclipse.actf.visualization.gui.msaa.properties.fields.MSAASELFLAGField;
import org.eclipse.actf.visualization.gui.msaa.properties.fields.TextField;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;

public abstract class MethodData {
    private String title;
    private boolean supportInvoke;
    private AbstractInputField[] inputFields = new AbstractInputField[0];
    protected Object result = PRESS_ENTER_MSG;
    private static final String PRESS_ENTER_MSG = Messages.props_pressEnter;
    private static final String PRESS_OK_MSG = Messages.props_pressOK;
    private static final String INVALID_FIELD_MSG = Messages.props_invalid;
    private static final String VALID_RANGE_MSG = Messages.props_range;
    private static final String SUCCESS_MSG = Messages.props_success;
    private static final String FAIL_MSG = Messages.props_fail;

    protected String getInvalidArgMessage(AbstractInputField abstractInputField) {
        int n;
        int n2;
        String string = abstractInputField.getLabelText();
        if (abstractInputField instanceof IntegerField && (n2 = ((IntegerField)abstractInputField).minValue) <= (n = ((IntegerField)abstractInputField).maxValue)) {
            return MessageFormat.format((String)VALID_RANGE_MSG, (Object[])new Object[]{string, new Integer(n2), new Integer(n)});
        }
        return MessageFormat.format((String)INVALID_FIELD_MSG, (Object[])new Object[]{string});
    }

    public MethodData(String string, boolean bl) {
        this.title = string;
        this.supportInvoke = bl;
    }

    public void setInputFields(AbstractInputField[] abstractInputFieldArray) {
        this.inputFields = abstractInputFieldArray;
    }

    public final String getTitle() {
        return this.title;
    }

    public final boolean canInvole() {
        return this.supportInvoke;
    }

    public boolean invoke() {
        return this.supportInvoke;
    }

    public Object getResult() {
        return this.result;
    }

    protected final void createControl(Composite composite) {
        int n = 0;
        while (n < this.inputFields.length) {
            this.inputFields[n].createLabelAndControl(composite);
            ++n;
        }
    }

    protected final boolean validate() {
        int n = 0;
        while (n < this.inputFields.length) {
            AbstractInputField abstractInputField = this.inputFields[n];
            if (!abstractInputField.validate()) {
                return false;
            }
            ++n;
        }
        return true;
    }

    protected final String getMessage() {
        int n = 0;
        while (n < this.inputFields.length) {
            AbstractInputField abstractInputField = this.inputFields[n];
            if (!abstractInputField.validate()) {
                return this.getInvalidArgMessage(abstractInputField);
            }
            ++n;
        }
        return PRESS_OK_MSG;
    }

    protected final void setModifyListener(ModifyListener modifyListener) {
        int n = 0;
        while (n < this.inputFields.length) {
            AbstractInputField abstractInputField = this.inputFields[n];
            abstractInputField.setModifyListener(modifyListener);
            ++n;
        }
    }

    protected final void update() {
        int n = 0;
        while (n < this.inputFields.length) {
            AbstractInputField abstractInputField = this.inputFields[n];
            abstractInputField.update();
            ++n;
        }
    }

    protected final String getParameters() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < this.inputFields.length) {
            if (n > 0) {
                stringBuffer.append(", ");
            }
            AbstractInputField abstractInputField = this.inputFields[n];
            stringBuffer.append(abstractInputField.getLabelText());
            stringBuffer.append("=");
            if (abstractInputField instanceof IA2CoordTypeField) {
                int n2 = ((IA2CoordTypeField)abstractInputField).getIntValue();
                stringBuffer.append(IA2.getCoordTypeText(n2));
            } else if (abstractInputField instanceof IA2ScrollTypeField) {
                int n3 = ((IA2ScrollTypeField)abstractInputField).getIntValue();
                stringBuffer.append(IA2.getScrollTypeText(n3));
            } else if (abstractInputField instanceof IA2TextBoundaryTypeField) {
                int n4 = ((IA2TextBoundaryTypeField)abstractInputField).getIntValue();
                stringBuffer.append(IA2.getTextBoundaryTypeText(n4));
            } else if (abstractInputField instanceof MSAASELFLAGField) {
                int n5 = ((MSAASELFLAGField)abstractInputField).getIntValue();
                stringBuffer.append("0x" + Integer.toHexString(n5));
            } else if (abstractInputField instanceof IntegerField) {
                int n6 = ((IntegerField)abstractInputField).getIntValue();
                stringBuffer.append(Integer.toString(n6));
            } else if (abstractInputField instanceof TextField) {
                String string = ((TextField)abstractInputField).getStringValue();
                stringBuffer.append(MethodData.T(string));
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    protected final String formatResult(boolean bl) {
        return this.formatResult(bl ? SUCCESS_MSG : FAIL_MSG);
    }

    protected final String formatResult(String string) {
        String string2 = this.getParameters();
        if (string2.length() > 0) {
            return String.valueOf(string) + " [" + string2 + "]";
        }
        return string;
    }

    protected static String T(String string) {
        if (string == null) {
            return "(null)";
        }
        return "\"" + string + "\"";
    }
}

