/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.internal.engines.blind.html.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.actf.util.logging.DebugPrintUtil;
import org.eclipse.actf.visualization.engines.blind.BlindVizResourceUtil;
import org.eclipse.actf.visualization.engines.blind.html.VisualizeEngine;
import org.eclipse.actf.visualization.engines.voicebrowser.IPacket;
import org.eclipse.actf.visualization.engines.voicebrowser.IPacketCollection;
import org.eclipse.actf.visualization.eval.problem.HighlightTargetId;
import org.eclipse.actf.visualization.eval.problem.IProblemItem;
import org.eclipse.actf.visualization.internal.engines.blind.html.BlindProblem;
import org.eclipse.actf.visualization.internal.engines.blind.html.util.DocumentCleaner;
import org.eclipse.actf.visualization.internal.engines.blind.html.util.VisualizationNodeInfo;
import org.eclipse.actf.visualization.internal.engines.blind.html.util.VisualizeMapDataImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VisualizeViewUtil {
    private static final String SCRIPT = "script";
    private static final String NAME = "name";
    private static final String TITLE = "title";
    private static final String HREF = "href";
    private static final String IMG = "img";
    private static final String NULL_STRING = "";
    private static final String BODY = "body";
    private static final String STYLE = "style";
    private static final String ID = "id";
    private static final String DIV = "div";
    private static final String INPUT = "input";
    private static final String IMAGE = "image";
    private static final String TYPE = "type";
    private static final String ON_CLICK = "onClick";
    private static final String ALT = "alt";
    private static final String SRC = "src";

    public static File prepareActions(Document document, VisualizeMapDataImpl visualizeMapDataImpl, String string, boolean bl) {
        Node node;
        Map<Node, Node> map = visualizeMapDataImpl.getIntraPageLinkMap();
        List<VisualizationNodeInfo> list = visualizeMapDataImpl.getNodeInfoList();
        NodeList nodeList = document.getElementsByTagName(BODY);
        int n = 0;
        while (n < nodeList.getLength()) {
            node = (Element)nodeList.item(n);
            DocumentCleaner.removeOnMouse((Element)node);
            DocumentCleaner.removeOnLoad((Element)node);
            ++n;
        }
        if (nodeList.getLength() == 0) {
            Element element = document.getDocumentElement();
            if (element != null) {
                element.appendChild(document.createElement(BODY));
            } else {
                DebugPrintUtil.devOrDebugPrintln((Object)"VisualizeViewUtil: no doc element");
                return null;
            }
        }
        Element element = document.createElement(DIV);
        element.setAttribute(STYLE, "position:absolute;pixelLeft= 10;pixelTop=10; color:red;font-size=12pt");
        element.setAttribute(ID, "test");
        node = nodeList.item(0);
        node.insertBefore(element, node.getFirstChild());
        VisualizeViewUtil.insertLinkIcon(document, map, string);
        VisualizeViewUtil.insertControlPane(document);
        nodeList = document.getElementsByTagName("map");
        if (nodeList != null) {
            int n2 = 0;
            while (n2 < nodeList.getLength()) {
                Element element2 = (Element)nodeList.item(n2);
                element2.setAttribute(ON_CLICK, "cancelMapLink(event)");
                ++n2;
            }
        }
        return VisualizeViewUtil.createScriptFile(document, list, string, bl);
    }

    private static void insertLinkIcon(Document document, Map<Node, Node> map, String string) {
        Iterator<Node> iterator = map.keySet().iterator();
        HashSet<String> hashSet = new HashSet<String>();
        int n = 0;
        while (iterator.hasNext()) {
            Element element = (Element)iterator.next();
            Element element2 = (Element)map.get(element);
            Element element3 = document.createElement(IMG);
            String string2 = element.getAttribute(HREF).substring(1);
            element3.setAttribute(ALT, "Intra-page link: " + string2);
            element3.setAttribute(TITLE, "Intra-page link: " + string2);
            element3.setAttribute(SRC, String.valueOf(string) + "img/jump.gif");
            element3.setAttribute(NAME, "jump" + n);
            if (element.hasChildNodes()) {
                element.insertBefore(element3, element.getFirstChild());
            } else {
                element.appendChild(element3);
            }
            if (!hashSet.contains(string2)) {
                Element element4 = document.createElement(IMG);
                element4.setAttribute(ALT, "Intra-page link destination: " + string2);
                element4.setAttribute(TITLE, "Intra-page link destination: " + string2);
                element4.setAttribute(SRC, String.valueOf(string) + "img/dest.gif");
                element4.setAttribute(NAME, string2);
                if (element2.hasChildNodes()) {
                    element2.insertBefore(element4, element2.getFirstChild());
                } else {
                    element2.appendChild(element4);
                }
                hashSet.add(string2);
            }
            ++n;
        }
    }

    private static void insertControlPane(Document document) {
        NodeList nodeList = document.getElementsByTagName(BODY);
        Element element = document.createElement(DIV);
        element.setAttribute(STYLE, "position:absolute;font-size: medium; background-color: #FFFFFF; border-color: #333333 #000000 #000000; padding-top: 5px; padding-right: 5px; padding-bottom: 5px; padding-left: 5px; border-style: solid; border-top-width: 1px; border-right-width: 1px; border-bottom-width: 1px; border-left-width: 1px");
        element.setAttribute(ID, "control_pane");
        Element element2 = document.createElement(INPUT);
        element2.setAttribute(TYPE, IMAGE);
        element2.setAttribute(SRC, "img/stop.gif");
        element2.setAttribute(ALT, "Stop/Move Balloon");
        element2.setAttribute(ON_CLICK, "control_moving()");
        element.appendChild(element2);
        Element element3 = document.createElement(INPUT);
        element3.setAttribute(TYPE, IMAGE);
        element3.setAttribute(SRC, "img/clear.gif");
        element3.setAttribute(ALT, "Clear Line");
        element3.setAttribute(ON_CLICK, "clean_Line()");
        Element element4 = document.createElement(INPUT);
        element4.setAttribute(TYPE, IMAGE);
        element4.setAttribute(SRC, "img/refresh.gif");
        element4.setAttribute(ALT, "Refresh Line");
        element4.setAttribute(ON_CLICK, "refresh_Jump()");
        Element element5 = document.createElement(INPUT);
        element5.setAttribute(TYPE, IMAGE);
        element5.setAttribute(SRC, "img/draw.gif");
        element5.setAttribute(ALT, "Draw All Line");
        element5.setAttribute(ON_CLICK, "draw_all_Line()");
        element.appendChild(element3);
        element.appendChild(element4);
        element.appendChild(element5);
        Node node = nodeList.item(0);
        node.insertBefore(element, node.getFirstChild());
    }

    private static File createScriptFile(Document document, List<VisualizationNodeInfo> list, String string, boolean bl) {
        try {
            Object object;
            Object object2;
            Object object3;
            File file = BlindVizResourceUtil.createTempFile((String)"variant", (String)".js");
            PrintWriter printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"));
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("var id2time = new Array();");
            stringBuffer.append("var id2comment = new Array();");
            int n = list.size();
            int n2 = 0;
            while (n2 < n) {
                object3 = list.get(n2);
                object2 = ((VisualizationNodeInfo)object3).getComment();
                object = new StringBuffer();
                int n3 = 0;
                while (n3 < ((String)object2).length()) {
                    if (((String)object2).charAt(n3) == '\"') {
                        ((StringBuffer)object).append("\\");
                    }
                    if (((String)object2).charAt(n3) == '\'') {
                        ((StringBuffer)object).append('\\');
                    }
                    ((StringBuffer)object).append(((String)object2).charAt(n3));
                    ++n3;
                }
                stringBuffer.append("id2time['id");
                stringBuffer.append(((VisualizationNodeInfo)object3).getId());
                stringBuffer.append("']=");
                stringBuffer.append(((VisualizationNodeInfo)object3).getTime());
                stringBuffer.append(";");
                stringBuffer.append("id2comment['id");
                stringBuffer.append(((VisualizationNodeInfo)object3).getId());
                stringBuffer.append("']='");
                stringBuffer.append(((StringBuffer)object).toString());
                stringBuffer.append("';");
                ++n2;
            }
            String string2 = stringBuffer.toString().replaceAll("\n", NULL_STRING).replaceAll("\r", NULL_STRING);
            printWriter.write(string2);
            stringBuffer = new StringBuffer();
            stringBuffer.append("var baloonSwitch = 1; ");
            stringBuffer.append("var baseUrl = '" + string + "'; ");
            stringBuffer.append("var acc_imageDir = 'img/'; ");
            if (bl) {
                stringBuffer.append("var servletMode = true; ");
            } else {
                stringBuffer.append("var servletMode = false; ");
            }
            stringBuffer.append("var isAlert = true; ");
            printWriter.write(stringBuffer.toString());
            printWriter.flush();
            printWriter.close();
            object3 = document.getElementsByTagName("head");
            if (object3.getLength() > 0) {
                object2 = (Element)object3.item(0);
                object = document.createElement(SCRIPT);
                object.setAttribute(SRC, String.valueOf(string) + file.getName());
                object2.appendChild((Node)object);
                Element element = document.createElement(SCRIPT);
                element.setAttribute(SRC, String.valueOf(string) + "img/highlight.js");
                object2.appendChild(element);
            }
            object2 = document.createElement(DIV);
            object2.setAttribute(STYLE, "position:absolute;font-size: medium; background-color: #FFFFFF; border-color: #333333 #000000 #000000; padding-top: 5px; padding-right: 5px; padding-bottom: 5px; padding-left: 5px; border-style: solid; border-top-width: 1px; border-right-width: 1px; border-bottom-width: 1px; border-left-width: 1px");
            object2.setAttribute(ID, "balloon");
            object = document.createElement(DIV);
            object.setAttribute(ID, "message");
            object.appendChild(document.createTextNode(NULL_STRING));
            object2.appendChild((Node)object);
            NodeList nodeList = document.getElementsByTagName(BODY);
            if (nodeList.getLength() > 0) {
                Element element = (Element)nodeList.item(0);
                element.insertBefore((Node)object2, element.getFirstChild());
            }
            return file;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static void visualizeError(Document document, List<IProblemItem> list, VisualizeMapDataImpl visualizeMapDataImpl, String string) {
        int n = list.size();
        int n2 = 0;
        while (n2 < n) {
            Object object;
            BlindProblem blindProblem = (BlindProblem)list.get(n2);
            Node node = blindProblem.getTargetNodeInResultDoc();
            Integer n3 = visualizeMapDataImpl.getIdOfNode(node);
            int n4 = blindProblem.getSubType();
            switch (n4) {
                case 2: 
                case 6: 
                case 10: 
                case 12: {
                    break;
                }
                default: {
                    if (n3 == null) break;
                    int n5 = n3;
                    blindProblem.setNodeId(n5);
                }
            }
            VisualizationNodeInfo visualizationNodeInfo = visualizeMapDataImpl.getNodeInfo(node);
            if (visualizationNodeInfo != null) {
                if (38 == blindProblem.getSubType()) {
                    visualizationNodeInfo.appendComment(blindProblem.getDescription().replaceAll("&", "&amp;"));
                } else {
                    visualizationNodeInfo.appendComment(blindProblem.getDescription());
                }
            } else if (node != null && node.getNodeType() == 1) {
                try {
                    object = ((Element)node).getAttribute(ID);
                    if (((String)object).startsWith(ID)) {
                        object = ((String)object).substring(2);
                    }
                }
                catch (Exception exception) {}
            }
            switch (blindProblem.getSubType()) {
                case 0: 
                case 4: 
                case 38: {
                    object = (Element)node;
                    Node node2 = visualizeMapDataImpl.getReplacement((Node)object);
                    if (node2 != null) {
                        object = (Element)node2;
                    }
                    Element element = VisualizeViewUtil.createErrorImageElement(node, blindProblem, n3, string);
                    object.appendChild(element);
                    break;
                }
                case 9: {
                    Object object2;
                    Object object3;
                    int n6 = -1;
                    int n7 = -1;
                    try {
                        object3 = blindProblem.getNodeList();
                        node = (Node)object3.get(1);
                        object2 = visualizeMapDataImpl.getIdOfNode(node);
                        if (object2 != null) {
                            n7 = (Integer)object2;
                        }
                    }
                    catch (NullPointerException nullPointerException) {
                        nullPointerException.printStackTrace();
                    }
                    if (n3 != null) {
                        n6 = n3;
                    } else if (n7 > -1) {
                        n6 = n7;
                    }
                    blindProblem.setNodeId(n6);
                    blindProblem.addNodeIds(new HighlightTargetId(n6, n6));
                    blindProblem.addNodeIds(new HighlightTargetId(n7, n7));
                    break;
                }
                case 8: 
                case 14: 
                case 17: 
                case 18: 
                case 19: 
                case 25: 
                case 26: 
                case 35: {
                    Object object3 = (Element)node;
                    Object object2 = VisualizeViewUtil.createErrorImageElement((Node)object3, blindProblem, n3, string);
                    object3.appendChild((Node)object2);
                    break;
                }
                case 15: {
                    Element element = VisualizeViewUtil.createErrorImageElement(node, blindProblem, n3, string);
                    if (node.getNodeType() == 1) {
                        node.appendChild(element);
                        break;
                    }
                    node.getParentNode().insertBefore(element, node);
                    break;
                }
                case 36: 
                case 37: {
                    Element element = VisualizeViewUtil.createErrorImageElement(node, blindProblem, n3, string);
                    node.getParentNode().insertBefore(element, node);
                }
            }
            ++n2;
        }
    }

    private static Element createErrorImageElement(Node node, IProblemItem iProblemItem, Integer n, String string) {
        Element element = node.getOwnerDocument().createElement(IMG);
        element.setAttribute(ALT, "error icon");
        if (38 == iProblemItem.getSubType()) {
            element.setAttribute(TITLE, iProblemItem.getDescription().replaceAll("&", "&amp;"));
        } else {
            element.setAttribute(TITLE, iProblemItem.getDescription());
        }
        element.setAttribute("onmouseover", "updateBaloon('id" + n + "');");
        element.setAttribute(SRC, String.valueOf(string) + "img/" + VisualizeEngine.ERROR_ICON_NAME);
        return element;
    }

    public static Document returnTextView(Document document, IPacketCollection iPacketCollection, String string) {
        Object object;
        Object object2;
        NodeList nodeList = document.getElementsByTagName(BODY);
        if (nodeList.getLength() > 0) {
            object2 = (Element)nodeList.item(0);
            object = object2.getChildNodes();
            int n = object.getLength();
            int n2 = n - 1;
            while (n2 >= 0) {
                object2.removeChild(object.item(n2));
                --n2;
            }
            n = iPacketCollection.size();
            boolean bl = false;
            boolean bl2 = false;
            int n3 = 0;
            while (n3 < n) {
                Element element;
                String string2;
                IPacket iPacket = (IPacket)iPacketCollection.get(n3);
                if (iPacket.getContext().isLinkTag()) {
                    bl2 = true;
                }
                if ((string2 = iPacket.getText()) != null && !string2.equals(NULL_STRING)) {
                    element = document.createElement("span");
                    element.appendChild(document.createTextNode(string2));
                    object2.appendChild(element);
                    if (bl2) {
                        element.setAttribute(STYLE, "text-decoration: underline;");
                    }
                    bl = false;
                }
                if (iPacket.getContext().isLineDelimiter() && !bl) {
                    element = document.createElement("br");
                    object2.appendChild(element);
                    bl = true;
                }
                if (!iPacket.getContext().isLinkTag()) {
                    bl2 = false;
                }
                ++n3;
            }
        }
        if ((object2 = document.getElementsByTagName("head")).getLength() > 0) {
            object = (Element)object2.item(0);
            Element element = document.createElement(SCRIPT);
            element.setAttribute(SRC, String.valueOf(string) + "img/highlight-dummy.js");
            object.appendChild(element);
        }
        return document;
    }
}

