/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.blind.odfbyhtml;

import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Vector;
import org.eclipse.actf.model.dom.html.HTMLParserFactory;
import org.eclipse.actf.model.dom.html.IErrorLogListener;
import org.eclipse.actf.model.dom.html.IHTMLParser;
import org.eclipse.actf.model.ui.IModelService;
import org.eclipse.actf.util.FileUtils;
import org.eclipse.actf.util.dom.DomPrintUtil;
import org.eclipse.actf.util.logging.DebugPrintUtil;
import org.eclipse.actf.visualization.blind.BlindVisualizerBase;
import org.eclipse.actf.visualization.blind.IBlindVisualizer;
import org.eclipse.actf.visualization.blind.ui.internal.Messages;
import org.eclipse.actf.visualization.engines.blind.BlindVizResourceUtil;
import org.eclipse.actf.visualization.engines.blind.eval.EvaluationResultBlind;
import org.eclipse.actf.visualization.engines.blind.html.IVisualizeMapData;
import org.eclipse.actf.visualization.engines.blind.html.VisualizeEngine;
import org.eclipse.actf.visualization.engines.blind.html.util.HtmlErrorLogListener;
import org.eclipse.actf.visualization.engines.blind.html.util.VisualizeReportUtil;
import org.eclipse.actf.visualization.eval.CheckTargetFactory;
import org.eclipse.actf.visualization.eval.EvaluationUtil;
import org.eclipse.actf.visualization.eval.ICheckTarget;
import org.eclipse.actf.visualization.eval.IChecker;
import org.eclipse.actf.visualization.eval.guideline.GuidelineHolder;
import org.eclipse.actf.visualization.eval.html.statistics.PageData;
import org.eclipse.actf.visualization.eval.problem.HighlightTargetNodeInfo;
import org.eclipse.actf.visualization.eval.problem.IProblemItem;
import org.eclipse.actf.visualization.eval.problem.IProblemItemVisitor;
import org.eclipse.actf.visualization.eval.problem.ProblemItemImpl;
import org.eclipse.actf.visualization.util.html2view.Html2ViewMapMaker;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlindVisualizerOdfByHtml
extends BlindVisualizerBase
implements IBlindVisualizer {
    private final String ODF_HTML_FILE_NAME = "ODF.html";
    private final String odf_html_fileS = String.valueOf(this.tmpDirS) + "ODF.html";
    private final String NO_ALT_IMAGE = "10101";
    private static final String MAPPED_HTML_FILE_PRE = "MappedHTML";
    private static final String HTML_SOURCE_FILE = "source.html";

    public boolean setModelService(IModelService iModelService) {
        if (super.setModelService(iModelService)) {
            if (this.targetUrl.startsWith("file://")) {
                this.targetUrl = this.targetUrl.substring(8);
            }
            this.targetUrl = this.targetUrl.replaceAll("%20", " ");
            return true;
        }
        return false;
    }

    public int visualize() {
        Document document;
        Vector vector;
        block13: {
            if (this.modelService == null) {
                return -1;
            }
            GuidelineHolder.getInstance().setTargetMimeType(this.modelService.getCurrentMIMEType());
            this.modelService.saveDocumentAsHTMLFile(this.odf_html_fileS);
            this.checkResult = new EvaluationResultBlind();
            FileUtils.copyFile((String)this.odf_html_fileS, (String)(String.valueOf(this.tmpDirS) + HTML_SOURCE_FILE), (boolean)true);
            vector = new Vector();
            IHTMLParser iHTMLParser = HTMLParserFactory.createHTMLParser();
            HtmlErrorLogListener htmlErrorLogListener = new HtmlErrorLogListener();
            iHTMLParser.addErrorLogListener((IErrorLogListener)htmlErrorLogListener);
            String string = String.valueOf(this.tmpDirS) + MAPPED_HTML_FILE_PRE + ".html";
            vector = Html2ViewMapMaker.makeMap((String)"ODF.html", (String)"MappedHTML.html", (String)this.tmpDirS);
            if (vector.size() == 0) {
                string = this.odf_html_fileS;
            }
            IHTMLParser iHTMLParser2 = HTMLParserFactory.createHTMLParser();
            iHTMLParser2.parse((InputStream)new FileInputStream(string));
            document = iHTMLParser2.getDocument();
            if (document != null) break block13;
            return -1;
        }
        try {
            this.setStatusMessage(Messages.BlindView_Now_processing);
            this.pageData = new PageData();
            VisualizeEngine visualizeEngine = new VisualizeEngine();
            visualizeEngine.setBaseUrl("");
            visualizeEngine.setTargetUrl(this.targetUrl);
            visualizeEngine.setDocument(document);
            visualizeEngine.setHtml2viewMapV(vector);
            visualizeEngine.setInvisibleIdSet(new HashSet());
            visualizeEngine.setPageData(this.pageData);
            visualizeEngine.visualize();
            this.maxReachingTime = visualizeEngine.getMaxTime();
            this.setInfoMessage(this.getMaxReachingTime());
            this.resultDocument = visualizeEngine.getResult();
            this.checkResult.setProblemList(visualizeEngine.getProbelems());
            this.checkResult.setTargetUrl(this.targetUrl);
            if (this.variantFile != null) {
                this.variantFile.delete();
            }
            this.variantFile = visualizeEngine.getVariantFile();
            this.checkResult.addAssociateFile(this.variantFile);
            IVisualizeMapData iVisualizeMapData = visualizeEngine.getVisualizeMapData();
            this.checkResult.setSourceFile(null);
            ArrayList<IProblemItem> arrayList = new ArrayList<IProblemItem>(1024);
            Document document2 = this.modelService.getDocument();
            ICheckTarget iCheckTarget = CheckTargetFactory.createCheckTarget((Document)document2, (String)this.modelService.getURL());
            iCheckTarget.setAdditionalDocument("html", document);
            IChecker[] iCheckerArray = EvaluationUtil.getCheckers();
            int n = 0;
            while (n < iCheckerArray.length) {
                if (iCheckerArray[n].isTargetFormat(this.modelService.getCurrentMIMEType()) && iCheckerArray[n].isEnabled()) {
                    long l = System.currentTimeMillis();
                    arrayList.addAll(iCheckerArray[n].check(iCheckTarget));
                    DebugPrintUtil.devOrDebugPrintln((Object)(System.currentTimeMillis() - l));
                }
                ++n;
            }
            this.visualizeError(this.resultDocument, arrayList);
            n = 0;
            while (n < arrayList.size()) {
                IProblemItem iProblemItem = arrayList.get(n);
                HighlightTargetNodeInfo highlightTargetNodeInfo = iProblemItem.getHighlightTargetNodeInfo();
                if (highlightTargetNodeInfo != null) {
                    iProblemItem.setHighlightTargetIds(highlightTargetNodeInfo.getHighlightTargetIds(iVisualizeMapData.getOrig2idMap()));
                }
                ++n;
            }
            this.checkResult.addProblemItems(arrayList);
            this.checkResult.accept((IProblemItemVisitor)this.pageData);
            if (this.resultFile != null) {
                this.resultFile.delete();
            }
            this.resultFile = BlindVizResourceUtil.createTempFile((String)"result", (String)".html");
            try {
                DomPrintUtil domPrintUtil = new DomPrintUtil(this.resultDocument);
                domPrintUtil.writeToFile(this.resultFile);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        catch (Exception exception) {
            this.setStatusMessage(Messages.Visualization_Error);
            exception.printStackTrace();
            return -1;
        }
        return 0;
    }

    public boolean isTarget(IModelService iModelService) {
        return iModelService != null && iModelService.getCurrentMIMEType().startsWith("application/vnd.oasis.opendocument.");
    }

    private void visualizeError(Document document, List<IProblemItem> list) {
        int n = list.size();
        int n2 = 0;
        while (n2 < n) {
            ProblemItemImpl problemItemImpl;
            IProblemItem iProblemItem = list.get(n2);
            if (iProblemItem instanceof ProblemItemImpl && (problemItemImpl = (ProblemItemImpl)iProblemItem).getId().equals("O_10101")) {
                VisualizeReportUtil.visualizeError((Document)document, (IProblemItem)problemItemImpl);
            }
            ++n2;
        }
    }
}

