/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.model.dom.dombycom.impl.object;

import java.util.ArrayList;
import org.eclipse.actf.model.dom.dombycom.IObjectElementFactory;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.Platform;

public class ObjectElementFactoryExtension {
    private static final String EXTENSION_NAME = "elementFactory";
    private static final String OBJECT_ELEMENT_FACTORY = "objectElementFactory";
    private static final String ATTR_IMPL = "implementations";
    private static ObjectElementFactoryExtension[] extensions;
    private static IObjectElementFactory[] factories;
    private IObjectElementFactory factory = null;

    static {
        factories = null;
    }

    public static IObjectElementFactory[] getObjectElementFactories() {
        if (factories != null) {
            return factories;
        }
        ObjectElementFactoryExtension[] objectElementFactoryExtensionArray = ObjectElementFactoryExtension.getExtensions();
        ArrayList<IObjectElementFactory> arrayList = new ArrayList<IObjectElementFactory>();
        if (objectElementFactoryExtensionArray != null) {
            int n = 0;
            while (n < objectElementFactoryExtensionArray.length) {
                IObjectElementFactory iObjectElementFactory = objectElementFactoryExtensionArray[n].getFactory();
                if (iObjectElementFactory != null) {
                    arrayList.add(iObjectElementFactory);
                }
                ++n;
            }
        }
        factories = new IObjectElementFactory[arrayList.size()];
        arrayList.toArray(factories);
        return factories;
    }

    private static ObjectElementFactoryExtension[] getExtensions() {
        if (extensions != null) {
            return extensions;
        }
        IExtension[] iExtensionArray = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.actf.model.dom.dombycom", EXTENSION_NAME).getExtensions();
        ArrayList<ObjectElementFactoryExtension> arrayList = new ArrayList<ObjectElementFactoryExtension>();
        int n = 0;
        while (n < iExtensionArray.length) {
            IConfigurationElement[] iConfigurationElementArray = iExtensionArray[n].getConfigurationElements();
            int n2 = 0;
            while (n2 < iConfigurationElementArray.length) {
                ObjectElementFactoryExtension objectElementFactoryExtension = ObjectElementFactoryExtension.parseExtension(iConfigurationElementArray[n2]);
                if (objectElementFactoryExtension != null) {
                    arrayList.add(objectElementFactoryExtension);
                }
                ++n2;
            }
            ++n;
        }
        extensions = arrayList.toArray(new ObjectElementFactoryExtension[arrayList.size()]);
        return extensions;
    }

    private static ObjectElementFactoryExtension parseExtension(IConfigurationElement iConfigurationElement) {
        if (!iConfigurationElement.getName().equals(OBJECT_ELEMENT_FACTORY)) {
            return null;
        }
        try {
            return new ObjectElementFactoryExtension(iConfigurationElement);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private ObjectElementFactoryExtension(IConfigurationElement iConfigurationElement) {
        try {
            this.factory = (IObjectElementFactory)iConfigurationElement.createExecutableExtension(ATTR_IMPL);
        }
        catch (Exception exception) {}
    }

    private IObjectElementFactory getFactory() {
        return this.factory;
    }
}

