/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.model.dom.html.errorhandler;

import java.io.IOException;
import java.util.Vector;
import org.eclipse.actf.model.dom.html.IErrorHandler;
import org.eclipse.actf.model.dom.html.IParser;
import org.eclipse.actf.model.dom.html.ParseException;
import org.eclipse.actf.model.internal.dom.sgml.impl.EndTag;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class FormInserter
implements IErrorHandler {
    private static final String FORM = "FORM";
    private String[] formName = new String[]{"FORM"};
    private String[] formCtrls = new String[]{"INPUT", "SELECT", "TEXTAREA", "LABEL", "BUTTON"};

    public boolean handleError(int n, IParser iParser, Node node) throws ParseException, IOException, SAXException {
        if (n != 5) {
            return false;
        }
        if (node instanceof EndTag && node.getNodeName().equalsIgnoreCase(FORM)) {
            Object object;
            Element element = iParser.getContext();
            Vector<Node> vector = new Vector<Node>();
            boolean bl = false;
            Node node2 = element.getLastChild();
            while (node2 != null) {
                if (node2 instanceof Element) {
                    object = (Element)node2;
                    if (this.hasElement((Element)object, this.formName)) break;
                    if (this.hasFormCtrl((Element)object)) {
                        bl = true;
                    }
                }
                vector.insertElementAt(node2, 0);
                node2 = node2.getPreviousSibling();
            }
            if (!bl) {
                return false;
            }
            node2 = iParser.getDocument().createElement(iParser.changeDefaultTagCase(FORM));
            object = vector.elements();
            while (object.hasMoreElements()) {
                Node node3 = (Node)object.nextElement();
                element.removeChild(node3);
                node2.insertBefore(node3, null);
            }
            element.insertBefore(node2, null);
            return true;
        }
        return false;
    }

    private boolean hasFormCtrl(Element element) {
        return this.hasElement(element, this.formCtrls);
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean hasElement(Element element, String[] stringArray) {
        Node node = element;
        while (node != null) {
            Node node2;
            if (node instanceof Element) {
                int n = 0;
                while (n < stringArray.length) {
                    if (node.getNodeName().equalsIgnoreCase(stringArray[n])) {
                        return true;
                    }
                    ++n;
                }
            }
            if ((node2 = node.getFirstChild()) == null) {
                if (node == element) {
                    return false;
                }
                node2 = node.getNextSibling();
            }
            while (node2 == null) {
                node2 = node.getParentNode();
                if ((node = node2) == element) {
                    return false;
                }
                node2 = node.getNextSibling();
            }
            node = node2;
        }
        return false;
    }
}

