/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.engines.blind.eval;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import org.eclipse.actf.ui.util.HighlightStringListener;
import org.eclipse.actf.visualization.eval.guideline.GuidelineHolder;
import org.eclipse.actf.visualization.eval.html.statistics.PageData;
import org.eclipse.actf.visualization.eval.problem.IProblemItem;
import org.eclipse.actf.visualization.internal.engines.blind.BlindVizEnginePlugin;
import org.eclipse.actf.visualization.internal.engines.blind.Messages;
import org.eclipse.actf.visualization.internal.engines.blind.SummaryEvaluation;
import org.eclipse.actf.visualization.util.RadarChart;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Display;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PageEvaluation {
    private GuidelineHolder guidelineHolder = GuidelineHolder.getInstance();
    private PageData pageData;
    private String[] metrics = this.guidelineHolder.getMetricsNames();
    private String[] lMetrics = this.guidelineHolder.getLocalizedMetricsNames();
    private int metricsSize = this.metrics.length;
    private int[] scores = new int[this.metricsSize];

    public static HighlightStringListener getHighLightStringListener() {
        HighlightStringListener highlightStringListener = new HighlightStringListener();
        Color color = Display.getDefault().getSystemColor(9);
        Color color2 = Display.getDefault().getSystemColor(3);
        if (Display.getDefault().getHighContrast()) {
            color = null;
            color2 = null;
        }
        highlightStringListener.addTarget(Messages.Eval_excellent, color, 1);
        highlightStringListener.addTarget(Messages.Eval_completely_compliant, color, 1);
        highlightStringListener.addTarget(Messages.Eval_completely_compliant_with_user_check_items, color, 1);
        highlightStringListener.addTarget(Messages.Eval_compliant_with_some_other_errors, color2, 1);
        highlightStringListener.addTarget(Messages.Eval_some_errors_on_metrics, color2, 1);
        highlightStringListener.addTarget(Messages.Eval_many_accessibility_issues, color2, 1);
        highlightStringListener.addTarget(Messages.Eval_some_accessibility_issues, color2, 1);
        highlightStringListener.addTarget(Messages.Eval_easy_for_blind_user_to_navigate, color, 1);
        highlightStringListener.addTarget(Messages.Eval_page_has_skiplinks_headings, color2, 1);
        highlightStringListener.addTarget(Messages.Eval_darkcolored_visualization_view, color2, 1);
        return highlightStringListener;
    }

    public PageEvaluation(List<IProblemItem> list, PageData pageData) {
        this.pageData = pageData;
        Arrays.fill(this.scores, 100);
        this.createPageReport(list, pageData);
    }

    private void addProblem(IProblemItem iProblemItem) {
        int[] nArray = iProblemItem.getEvaluationItem().getMetricsScores();
        if (nArray.length == this.metricsSize) {
            int n = 0;
            while (n < this.metricsSize) {
                int n2 = n;
                this.scores[n2] = this.scores[n2] - nArray[n];
                ++n;
            }
        }
    }

    private void checkMinus() {
        int n = 0;
        while (n < this.metricsSize) {
            if (this.scores[n] < 0) {
                this.scores[n] = 0;
            }
            ++n;
        }
    }

    private void setInvalidLinkRatio(double d) {
    }

    protected boolean hasComplianceError() {
        int n = 0;
        while (n < this.metricsSize) {
            if ((this.metrics[n].equalsIgnoreCase("perceivable") || this.metrics[n].equalsIgnoreCase("understandable") || this.metrics[n].equalsIgnoreCase("robust") || this.metrics[n].equalsIgnoreCase("operable")) && this.scores[n] != 100) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public String[] getAllResult() {
        Vector<String> vector = new Vector<String>();
        vector.add("Page Rating");
        vector.add(this.getOverallRating());
        boolean[] blArray = this.guidelineHolder.getMatchedMetrics();
        int n = 0;
        while (n < this.metricsSize) {
            if (blArray[n]) {
                vector.add(this.lMetrics[n]);
                vector.add(String.valueOf(this.scores[n]));
            }
            ++n;
        }
        String[] stringArray = new String[vector.size()];
        vector.toArray(stringArray);
        return stringArray;
    }

    private int getMinScore() {
        int n = 100;
        boolean[] blArray = GuidelineHolder.getInstance().getMatchedMetrics();
        int n2 = 0;
        while (n2 < this.metricsSize) {
            if (blArray[n2] && n > this.scores[n2]) {
                n = this.scores[n2];
            }
            ++n2;
        }
        return n;
    }

    public String getOverallRating() {
        int n = this.getMinScore();
        String string = Messages.PageEvaluation_Bad;
        if (n == 100) {
            string = Messages.PageEvaluation_Excellent;
        } else if (n >= 75) {
            string = Messages.PageEvaluation_Good;
        } else if (n >= 50) {
            string = Messages.PageEvaluation_Poor;
        }
        return string;
    }

    public String getSummary() {
        SummaryEvaluation summaryEvaluation = new SummaryEvaluation(this, this.pageData, this.hasComplianceError());
        return summaryEvaluation.getOverview();
    }

    public String getRatingIcon() {
        int n = this.getMinScore();
        String string = "Bad.png";
        if (n == 100) {
            string = "VeryGood.png";
        } else if (n >= 75) {
            string = "Good.png";
        } else if (n >= 50) {
            string = "Poor.png";
        }
        return string;
    }

    private void createPageReport(List<IProblemItem> list, PageData pageData) {
        Object object2;
        for (Object object2 : list) {
            this.addProblem((IProblemItem)object2);
        }
        this.setInvalidLinkRatio(pageData.getInvalidLinkRatio());
        this.checkMinus();
        object2 = GuidelineHolder.getInstance().getMatchedMetrics();
        String[] stringArray = this.lMetrics;
        int[] nArray = this.getScores();
        Vector<String> vector = new Vector<String>();
        Vector<Integer> vector2 = new Vector<Integer>();
        int n = 0;
        while (n < ((IProblemItem)object2).length) {
            if (object2[n] != false) {
                vector.add(stringArray[n]);
                vector2.add(new Integer(nArray[n]));
            }
            ++n;
        }
        stringArray = new String[vector.size()];
        vector.toArray(stringArray);
        nArray = new int[vector2.size()];
        n = 0;
        while (n < vector2.size()) {
            nArray[n] = (Integer)vector2.get(n);
            ++n;
        }
        try {
            RadarChart radarChart = new RadarChart(stringArray, nArray);
            radarChart.writeToPNG(new File(BlindVizEnginePlugin.getTempDirectory(), "pagerating.png"));
        }
        catch (Exception exception) {}
    }

    public String[] getMetrics() {
        return this.metrics;
    }

    public String[] getLocalizedMetrics() {
        return this.lMetrics;
    }

    public int[] getScores() {
        return this.scores;
    }

    public PageData getPageData() {
        return this.pageData;
    }
}

