/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.util.httpproxy.util;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.SortedMap;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CacheMap
extends TreeMap<String, Object> {
    private static final long serialVersionUID = 6681131647931821052L;
    private final int maxSize;
    private final int evictSize;
    private final LinkedList<Object> accessList = new LinkedList();

    public CacheMap(int n, int n2) {
        this.maxSize = n;
        this.evictSize = n2;
    }

    private void evict() {
        Iterator iterator = this.accessList.iterator();
        int n = 0;
        while (n < this.evictSize) {
            if (!iterator.hasNext()) {
                return;
            }
            Object e = iterator.next();
            this.remove(e);
            iterator.remove();
            ++n;
        }
    }

    private int searchAccessList(Object object) {
        return this.accessList.indexOf(object);
    }

    private void accessEntry(Object object) {
        int n = this.searchAccessList(object);
        if (n >= 0) {
            this.accessList.remove(n);
        }
        this.accessList.add(object);
    }

    @Override
    public Object put(String string, Object object) {
        if (this.size() >= this.maxSize) {
            this.evict();
        }
        this.accessEntry(string);
        return super.put(string, object);
    }

    @Override
    public Object get(Object object) {
        this.accessEntry(object);
        return super.get(object);
    }

    public Object matchStartsWith(String string) {
        String string2;
        SortedMap sortedMap = super.tailMap(string);
        try {
            string2 = sortedMap.firstKey();
        }
        catch (NoSuchElementException noSuchElementException) {
            return null;
        }
        if (!(string2 instanceof String)) {
            return null;
        }
        String string3 = string2;
        if (!string3.startsWith(string)) {
            return null;
        }
        return super.get(string3);
    }
}

