/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.autotools.ui.editors;

import org.eclipse.cdt.autotools.ui.editors.AutoconfAnnotationHover;
import org.eclipse.cdt.autotools.ui.editors.AutoconfEditor;
import org.eclipse.cdt.autotools.ui.editors.AutoconfMacroContentAssistProcessor;
import org.eclipse.cdt.autotools.ui.editors.AutoconfReconcilingStrategy;
import org.eclipse.cdt.internal.autotools.ui.editors.autoconf.AutoconfPresentationReconciler;
import org.eclipse.cdt.internal.autotools.ui.text.hover.AutoconfTextHover;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.MonoReconciler;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.ui.editors.text.TextSourceViewerConfiguration;

public class AutoconfSourceViewerConfiguration
extends TextSourceViewerConfiguration {
    private ITextHover acHover;
    private IAnnotationHover aaHover;
    private AutoconfEditor fEditor;

    public AutoconfSourceViewerConfiguration(IPreferenceStore prefs, AutoconfEditor editor) {
        super(prefs);
        this.fEditor = editor;
    }

    public String getConfiguredDocumentPartitioning(ISourceViewer sourceViewer) {
        return "autoconf_partitioning";
    }

    public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
        ContentAssistant assistant = new ContentAssistant();
        AutoconfMacroContentAssistProcessor macroContentAssistProcessor = new AutoconfMacroContentAssistProcessor(this.fEditor);
        assistant.setContentAssistProcessor((IContentAssistProcessor)macroContentAssistProcessor, "autoconf_macro");
        assistant.setContentAssistProcessor((IContentAssistProcessor)macroContentAssistProcessor, "__dftl_partition_content_type");
        assistant.enableAutoActivation(true);
        assistant.setAutoActivationDelay(500);
        assistant.setProposalPopupOrientation(10);
        assistant.setContextInformationPopupOrientation(20);
        assistant.setInformationControlCreator(AutoconfTextHover.getInformationControlCreator());
        return assistant;
    }

    public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
        return new String[]{"__dftl_partition_content_type", "autoconf_macro", "autoconf_comment"};
    }

    public ITextHover getTextHover(ISourceViewer sourceViewer, String contentType) {
        if (this.acHover == null) {
            this.acHover = new AutoconfTextHover(this.fEditor);
        }
        return this.acHover;
    }

    public IAnnotationHover getAnnotationHover(ISourceViewer sourceViewer) {
        if (this.aaHover == null) {
            this.aaHover = new AutoconfAnnotationHover();
        }
        return this.aaHover;
    }

    public IReconciler getReconciler(ISourceViewer sourceViewer) {
        MonoReconciler reconciler = new MonoReconciler((IReconcilingStrategy)new AutoconfReconcilingStrategy(this.fEditor), false);
        reconciler.setDelay(1000);
        reconciler.setProgressMonitor((IProgressMonitor)new NullProgressMonitor());
        return reconciler;
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        return new AutoconfPresentationReconciler();
    }
}

