/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.internal.core.makefile.gnu;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.eclipse.cdt.core.IMarkerGenerator;
import org.eclipse.cdt.core.ProblemMarkerInfo;
import org.eclipse.cdt.make.core.makefile.IBadDirective;
import org.eclipse.cdt.make.core.makefile.IDirective;
import org.eclipse.cdt.make.core.makefile.IMakefileValidator;
import org.eclipse.cdt.make.core.makefile.ISpecialRule;
import org.eclipse.cdt.make.core.makefile.gnu.IConditional;
import org.eclipse.cdt.make.core.makefile.gnu.ITerminal;
import org.eclipse.cdt.make.core.makefile.gnu.IVariableDefinition;
import org.eclipse.cdt.make.internal.core.makefile.MakefileMessages;
import org.eclipse.cdt.make.internal.core.makefile.gnu.GNUMakefile;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

public class GNUMakefileValidator
implements IMakefileValidator {
    IMarkerGenerator reporter;

    public GNUMakefileValidator() {
    }

    public GNUMakefileValidator(IMarkerGenerator errorHandler) {
        this.setMarkerGenerator(errorHandler);
    }

    @Override
    public void setMarkerGenerator(IMarkerGenerator errorHandler) {
        this.reporter = errorHandler;
    }

    public IMarkerGenerator getMarkerGenerator() {
        if (this.reporter == null) {
            this.reporter = new IMarkerGenerator(){

                public void addMarker(IResource file, int lineNumber, String errorDesc, int severity, String errorVar) {
                    ProblemMarkerInfo problemMarkerInfo = new ProblemMarkerInfo(file, lineNumber, errorDesc, severity, errorVar, null);
                    this.addMarker(problemMarkerInfo);
                }

                public void addMarker(ProblemMarkerInfo problemMarkerInfo) {
                    String name = "Makefile";
                    if (problemMarkerInfo.file != null) {
                        name = problemMarkerInfo.file.getName();
                    }
                    StringBuilder sb = new StringBuilder(name);
                    sb.append(':').append(problemMarkerInfo.lineNumber).append(':').append(this.getSeverity(problemMarkerInfo.severity));
                    if (problemMarkerInfo.description != null) {
                        sb.append(':').append(problemMarkerInfo.description);
                    }
                    if (problemMarkerInfo.variableName != null) {
                        sb.append(':').append(problemMarkerInfo.variableName);
                    }
                    if (problemMarkerInfo.externalPath != null) {
                        sb.append(':').append(problemMarkerInfo.externalPath);
                    }
                    sb.append('\n');
                    System.out.println(sb.toString());
                }

                public String getSeverity(int severity) {
                    if (severity == 3) {
                        return MakefileMessages.getString("MakefileValidator.errorBuild");
                    }
                    if (severity == 2) {
                        return MakefileMessages.getString("MakefileValidator.errorResource");
                    }
                    if (severity == 0) {
                        return MakefileMessages.getString("MakefileValidator.warningInfo");
                    }
                    if (severity == 1) {
                        return MakefileMessages.getString("MakefileValidator.warning");
                    }
                    return MakefileMessages.getString("MakefileValidator.unknown");
                }
            };
        }
        return this.reporter;
    }

    /*
     * Loose catch block
     */
    @Override
    public void checkFile(IFile file, IProgressMonitor monitor) {
        block17: {
            String message = MakefileMessages.getString("MakefileValidator.checkingFile") + file.getFullPath().toString();
            monitor.subTask(message);
            GNUMakefile gnu = new GNUMakefile();
            InputStream stream = null;
            try {
                stream = file.getContents();
                InputStreamReader source = new InputStreamReader(stream);
                gnu.parse(file.getFullPath().toString(), (Reader)source);
                this.validateDirectives((IResource)file, gnu.getDirectives());
            }
            catch (CoreException coreException) {
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (IOException iOException) {}
                }
                break block17;
            }
            catch (IOException iOException) {
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (IOException iOException2) {}
                }
                break block17;
                catch (Throwable throwable) {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (IOException iOException3) {
                            // empty catch block
                        }
                    }
                    throw throwable;
                }
            }
            if (stream == null) break block17;
            try {
                stream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        monitor.subTask(MakefileMessages.getString("MakefileValidator.fileChecked"));
        monitor.done();
    }

    public void validateDirectives(IResource res, IDirective[] directives) {
        int startLine;
        IMarkerGenerator marker = this.getMarkerGenerator();
        int conditionCount = 0;
        int defineCount = 0;
        IDirective directive = null;
        int i = 0;
        while (i < directives.length) {
            directive = directives[i];
            if (directive instanceof IConditional) {
                IConditional condition = (IConditional)directive;
                this.validateCondition(condition);
                if (!condition.isElse()) {
                    ++conditionCount;
                } else if (conditionCount == 0) {
                    int startLine2 = condition.getStartLine();
                    String msg = MakefileMessages.getString("MakefileValidator.error.elseMissingIfCondition");
                    int severity = 2;
                    varName = condition.toString().trim();
                    marker.addMarker(res, startLine2, msg, severity, varName);
                }
            } else if (directive instanceof ITerminal) {
                ITerminal terminal = (ITerminal)directive;
                if (terminal.isEndif()) {
                    if (conditionCount == 0) {
                        int startLine3 = terminal.getStartLine();
                        String msg = MakefileMessages.getString("MakefileValidator.error.endifMissingIfElseCondition");
                        int severity = 2;
                        varName = terminal.toString().trim();
                        marker.addMarker(res, startLine3, msg, severity, varName);
                    } else {
                        --conditionCount;
                    }
                } else if (terminal.isEndef()) {
                    if (defineCount == 0) {
                        int startLine4 = terminal.getStartLine();
                        String msg = MakefileMessages.getString("MakefileValidator.error.endefMissingOverrideDefine");
                        int severity = 2;
                        varName = terminal.toString().trim();
                        marker.addMarker(res, startLine4, msg, severity, varName);
                    } else {
                        --defineCount;
                    }
                }
            } else if (directive instanceof IVariableDefinition) {
                IVariableDefinition definition = (IVariableDefinition)directive;
                if (definition.isMultiLine()) {
                    ++defineCount;
                }
            } else if (directive instanceof IBadDirective) {
                int startLine5 = directive.getStartLine();
                String msg = MakefileMessages.getString("MakefileValidator.error.unknownDirective");
                int severity = 2;
                String varName = directive.toString().trim();
                marker.addMarker(res, startLine5, msg, severity, varName);
            } else if (directive instanceof ISpecialRule) {
                this.validateSpecialRule((ISpecialRule)directive);
            }
            ++i;
        }
        if (conditionCount > 0) {
            startLine = 0;
            String varName = "";
            int severity = 2;
            int i2 = directives.length - 1;
            while (i2 >= 0) {
                if (directives[i2] instanceof IConditional) {
                    startLine = directives[i2].getStartLine();
                    varName = directives[i2].toString().trim();
                    break;
                }
                --i2;
            }
            String msg = MakefileMessages.getString("MakefileValidator.error.noMatchingEndifForCondition");
            marker.addMarker(res, startLine, msg, severity, varName);
        }
        if (defineCount > 0) {
            startLine = 0;
            String varName = "";
            int severity = 2;
            int i3 = directives.length - 1;
            while (i3 >= 0) {
                IVariableDefinition definition;
                if (directives[i3] instanceof IVariableDefinition && (definition = (IVariableDefinition)directives[i3]).isMultiLine()) {
                    startLine = definition.getStartLine();
                    varName = definition.toString().trim();
                    break;
                }
                --i3;
            }
            String msg = MakefileMessages.getString("MakefileValidator.error.noMatchingEndefForOverrideDefine");
            marker.addMarker(res, startLine, msg, severity, varName);
        }
    }

    public void validateCondition(IConditional condition) {
    }

    public void validateSpecialRule(ISpecialRule rule) {
    }
}

