/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.typehierarchy;

import java.text.MessageFormat;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.internal.ui.text.AbstractInformationControl;
import org.eclipse.cdt.internal.ui.typehierarchy.ITHModelPresenter;
import org.eclipse.cdt.internal.ui.typehierarchy.Messages;
import org.eclipse.cdt.internal.ui.typehierarchy.THContentProvider;
import org.eclipse.cdt.internal.ui.typehierarchy.THHierarchyModel;
import org.eclipse.cdt.internal.ui.typehierarchy.THLabelProvider;
import org.eclipse.cdt.internal.ui.typehierarchy.THNode;
import org.eclipse.cdt.internal.ui.typehierarchy.TypeHierarchyUI;
import org.eclipse.cdt.internal.ui.viewsupport.EditorOpener;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.jface.bindings.Trigger;
import org.eclipse.jface.bindings.TriggerSequence;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.bindings.keys.SWTKeySupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;

public class THInformationControl
extends AbstractInformationControl
implements ITHModelPresenter {
    private THHierarchyModel fModel;
    private THLabelProvider fHierarchyLabelProvider;
    private TreeViewer fHierarchyTreeViewer;
    private boolean fDisposed;
    private KeyAdapter fKeyAdapter;

    public THInformationControl(Shell parent, int shellStyle, int treeStyle) {
        super(parent, shellStyle, treeStyle, "org.eclipse.cdt.ui.edit.open.quick.type.hierarchy", true);
    }

    private KeyAdapter getKeyAdapter() {
        if (this.fKeyAdapter == null) {
            this.fKeyAdapter = new KeyAdapter(){

                public void keyPressed(KeyEvent e) {
                    int accelerator = SWTKeySupport.convertEventToUnmodifiedAccelerator((KeyEvent)e);
                    KeyStroke keyStroke = SWTKeySupport.convertAcceleratorToKeyStroke((int)accelerator);
                    Trigger[] triggers = THInformationControl.this.getInvokingCommandTriggerSequence().getTriggers();
                    if (triggers == null) {
                        return;
                    }
                    Trigger[] triggerArray = triggers;
                    int n = triggers.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Trigger trigger = triggerArray[n2];
                        if (trigger.equals((Object)keyStroke)) {
                            e.doit = false;
                            THInformationControl.this.toggleHierarchy();
                            return;
                        }
                        ++n2;
                    }
                }
            };
        }
        return this.fKeyAdapter;
    }

    @Override
    protected boolean hasHeader() {
        return true;
    }

    @Override
    protected Text createFilterText(Composite parent) {
        Text text = super.createFilterText(parent);
        text.addKeyListener((KeyListener)this.getKeyAdapter());
        return text;
    }

    @Override
    protected TreeViewer createTreeViewer(Composite parent, int style) {
        Display display = this.getShell().getDisplay();
        this.fModel = new THHierarchyModel(this, display, true);
        this.fHierarchyLabelProvider = new THLabelProvider(display, this.fModel);
        this.fHierarchyLabelProvider.setMarkImplementers(false);
        this.fHierarchyTreeViewer = new TreeViewer(parent, 2816);
        this.fHierarchyTreeViewer.setContentProvider((IContentProvider)new THContentProvider());
        this.fHierarchyTreeViewer.setLabelProvider((IBaseLabelProvider)this.fHierarchyLabelProvider);
        this.fHierarchyTreeViewer.setComparator(new ViewerComparator());
        this.fHierarchyTreeViewer.setUseHashlookup(true);
        this.fHierarchyTreeViewer.getTree().addKeyListener((KeyListener)this.getKeyAdapter());
        return this.fHierarchyTreeViewer;
    }

    protected void onOpenElement(ISelection selection) {
        ICElement elem = (ICElement)this.getSelectedElement();
        if (elem != null) {
            try {
                EditorOpener.open(CUIPlugin.getActivePage(), elem);
            }
            catch (CModelException e) {
                CUIPlugin.log(e);
            }
        }
    }

    @Override
    public void setInput(Object input) {
        ICElement[] splitInput;
        if (input instanceof ICElement[] && TypeHierarchyUI.isValidTypeInput((splitInput = (ICElement[])input)[0])) {
            this.fModel.setInput(splitInput[0], splitInput[1]);
            this.fHierarchyLabelProvider.setHideNonImplementers(splitInput[1] != null);
            this.fHierarchyTreeViewer.setInput((Object)this.fModel);
            this.fModel.computeGraph();
            this.updateTitle();
        }
    }

    protected void updateTitle() {
        this.setTitleText(this.computeTitleText());
    }

    private String computeTitleText() {
        ICElement input = this.fModel.getInput();
        ICElement member = this.fModel.getSelectedMember();
        String elemName = member != null ? member.getElementName() : input.getElementName();
        return NLS.bind((String)this.getFormatString(this.fModel.getHierarchyKind(), member != null), (Object)elemName);
    }

    private String getFormatString(int hierarchyKind, boolean forMember) {
        switch (hierarchyKind) {
            case 1: {
                return forMember ? Messages.THInformationControl_titleMemberInSubHierarchy : Messages.THInformationControl_titleSubHierarchy;
            }
            case 2: {
                return forMember ? Messages.THInformationControl_titleMemberInSuperHierarchy : Messages.THInformationControl_titleSuperHierarchy;
            }
        }
        return forMember ? Messages.THInformationControl_titleMemberInHierarchy : Messages.THInformationControl_titleHierarchy;
    }

    @Override
    protected String getId() {
        return "org.eclipse.cdt.internal.ui.typehierarchy.QuickHierarchy";
    }

    @Override
    protected Object getSelectedElement() {
        THNode node = this.selectionToNode(this.fHierarchyTreeViewer.getSelection());
        if (node != null) {
            ICElement elem = node.getElement();
            if (node.isImplementor()) {
                this.fModel.onHierarchySelectionChanged(node);
                ICElement melem = this.fModel.getSelectedMember();
                if (melem != null) {
                    return melem;
                }
            }
            return elem;
        }
        return null;
    }

    private THNode selectionToNode(ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection ss = (IStructuredSelection)selection;
            for (Object cand : ss) {
                if (!(cand instanceof THNode)) continue;
                return (THNode)cand;
            }
        }
        return null;
    }

    @Override
    public void widgetDisposed(DisposeEvent event) {
        this.fDisposed = true;
        super.widgetDisposed(event);
    }

    @Override
    public void onEvent(int event) {
        if (!this.fDisposed) {
            switch (event) {
                case 0: {
                    if (this.fModel.hasTrivialHierarchy()) {
                        this.fHierarchyLabelProvider.setHideNonImplementers(false);
                    }
                    this.fHierarchyTreeViewer.refresh();
                    THNode selection = this.fModel.getSelectionInHierarchy();
                    if (selection == null) break;
                    this.fHierarchyTreeViewer.setSelection((ISelection)new StructuredSelection((Object)selection));
                    this.fHierarchyTreeViewer.expandToLevel((Object)selection, 2);
                }
            }
        }
    }

    @Override
    public void setMessage(String msg) {
    }

    @Override
    public IWorkbenchSiteProgressService getProgressService() {
        return null;
    }

    @Override
    protected String getStatusFieldText() {
        TriggerSequence sequence = this.getInvokingCommandTriggerSequence();
        String keyName = "";
        if (sequence != null) {
            keyName = sequence.format();
        }
        String message = "";
        switch (this.fModel.getHierarchyKind()) {
            case 0: {
                message = Messages.THInformationControl_toggle_superTypeHierarchy_label;
                break;
            }
            case 1: {
                message = Messages.THInformationControl_toggle_typeHierarchy_label;
                break;
            }
            case 2: {
                message = Messages.THInformationControl_toggle_subTypeHierarchy_label;
                break;
            }
        }
        return MessageFormat.format(message, keyName);
    }

    @Override
    protected void selectFirstMatch() {
        Tree tree = this.fHierarchyTreeViewer.getTree();
        THNode element = this.findElement(tree.getItems());
        if (element != null) {
            this.fHierarchyTreeViewer.setSelection((ISelection)new StructuredSelection((Object)element), true);
        } else {
            this.fHierarchyTreeViewer.setSelection((ISelection)StructuredSelection.EMPTY);
        }
    }

    protected void toggleHierarchy() {
        this.fHierarchyTreeViewer.getTree().setRedraw(false);
        switch (this.fModel.getHierarchyKind()) {
            case 0: {
                this.fModel.setHierarchyKind(2);
                break;
            }
            case 1: {
                this.fModel.setHierarchyKind(0);
                break;
            }
            case 2: {
                this.fModel.setHierarchyKind(1);
                break;
            }
        }
        this.fHierarchyTreeViewer.refresh();
        this.fHierarchyTreeViewer.expandAll();
        this.fHierarchyTreeViewer.getTree().setRedraw(true);
        this.updateStatusFieldText();
        this.updateTitle();
    }

    private THNode findElement(TreeItem[] items) {
        TreeItem[] treeItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item2 = treeItemArray[n2];
            Object item = item2.getData();
            THNode element = null;
            if (item instanceof THNode) {
                element = (THNode)item;
                if (this.fStringMatcher == null) {
                    return element;
                }
                String label = this.fHierarchyLabelProvider.getText(element);
                if (this.fStringMatcher.match(label)) {
                    return element;
                }
            }
            if ((element = this.findElement(item2.getItems())) != null) {
                return element;
            }
            ++n2;
        }
        return null;
    }
}

