/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.internal.vectorization;

import java.io.IOException;
import java.util.Optional;
import org.apache.lucene.codecs.hnsw.DefaultFlatVectorScorer;
import org.apache.lucene.codecs.hnsw.FlatVectorsScorer;
import org.apache.lucene.codecs.lucene95.HasIndexSlice;
import org.apache.lucene.index.ByteVectorValues;
import org.apache.lucene.index.KnnVectorValues;
import org.apache.lucene.index.VectorSimilarityFunction;
import org.apache.lucene.internal.vectorization.Lucene99MemorySegmentByteVectorScorer;
import org.apache.lucene.internal.vectorization.Lucene99MemorySegmentByteVectorScorerSupplier;
import org.apache.lucene.util.hnsw.RandomVectorScorer;
import org.apache.lucene.util.hnsw.RandomVectorScorerSupplier;
import org.apache.lucene.util.quantization.QuantizedByteVectorValues;

public class Lucene99MemorySegmentFlatVectorsScorer
implements FlatVectorsScorer {
    public static final Lucene99MemorySegmentFlatVectorsScorer INSTANCE = new Lucene99MemorySegmentFlatVectorsScorer(DefaultFlatVectorScorer.INSTANCE);
    private final FlatVectorsScorer delegate;

    private Lucene99MemorySegmentFlatVectorsScorer(FlatVectorsScorer delegate) {
        this.delegate = delegate;
    }

    @Override
    public RandomVectorScorerSupplier getRandomVectorScorerSupplier(VectorSimilarityFunction similarityType, KnnVectorValues vectorValues) throws IOException {
        Optional<RandomVectorScorerSupplier> scorer;
        HasIndexSlice byteVectorValues;
        ByteVectorValues bvv;
        assert (!(vectorValues instanceof QuantizedByteVectorValues));
        if (vectorValues instanceof ByteVectorValues && (bvv = (ByteVectorValues)vectorValues) instanceof HasIndexSlice && (byteVectorValues = (HasIndexSlice)((Object)bvv)).getSlice() != null && (scorer = Lucene99MemorySegmentByteVectorScorerSupplier.create(similarityType, byteVectorValues.getSlice(), vectorValues)).isPresent()) {
            return scorer.get();
        }
        return this.delegate.getRandomVectorScorerSupplier(similarityType, vectorValues);
    }

    @Override
    public RandomVectorScorer getRandomVectorScorer(VectorSimilarityFunction similarityType, KnnVectorValues vectorValues, float[] target) throws IOException {
        return this.delegate.getRandomVectorScorer(similarityType, vectorValues, target);
    }

    @Override
    public RandomVectorScorer getRandomVectorScorer(VectorSimilarityFunction similarityType, KnnVectorValues vectorValues, byte[] queryVector) throws IOException {
        Optional<Lucene99MemorySegmentByteVectorScorer> scorer;
        HasIndexSlice byteVectorValues;
        ByteVectorValues bvv;
        Lucene99MemorySegmentFlatVectorsScorer.checkDimensions(queryVector.length, vectorValues.dimension());
        assert (!(vectorValues instanceof QuantizedByteVectorValues));
        if (vectorValues instanceof ByteVectorValues && (bvv = (ByteVectorValues)vectorValues) instanceof HasIndexSlice && (byteVectorValues = (HasIndexSlice)((Object)bvv)).getSlice() != null && (scorer = Lucene99MemorySegmentByteVectorScorer.create(similarityType, byteVectorValues.getSlice(), vectorValues, queryVector)).isPresent()) {
            return scorer.get();
        }
        return this.delegate.getRandomVectorScorer(similarityType, vectorValues, queryVector);
    }

    static void checkDimensions(int queryLen, int fieldLen) {
        if (queryLen != fieldLen) {
            throw new IllegalArgumentException("vector query dimension: " + queryLen + " differs from field dimension: " + fieldLen);
        }
    }

    public String toString() {
        return "Lucene99MemorySegmentFlatVectorsScorer()";
    }
}

