/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.codan.core.cxx.externaltool;

import java.net.URI;
import org.eclipse.cdt.codan.core.CodanRuntime;
import org.eclipse.cdt.codan.core.cxx.Activator;
import org.eclipse.cdt.codan.core.cxx.externaltool.ArgsSeparator;
import org.eclipse.cdt.codan.core.cxx.externaltool.ConfigurationSettings;
import org.eclipse.cdt.codan.core.cxx.externaltool.IInvocationParametersProvider;
import org.eclipse.cdt.codan.core.cxx.externaltool.InvocationFailure;
import org.eclipse.cdt.codan.core.cxx.externaltool.InvocationParameters;
import org.eclipse.cdt.codan.core.cxx.externaltool.InvocationParametersProvider;
import org.eclipse.cdt.codan.core.cxx.externaltool.SingleConfigurationSetting;
import org.eclipse.cdt.codan.core.cxx.internal.externaltool.ExternalToolInvoker;
import org.eclipse.cdt.codan.core.model.AbstractCheckerWithProblemPreferences;
import org.eclipse.cdt.codan.core.model.CheckerLaunchMode;
import org.eclipse.cdt.codan.core.model.IProblem;
import org.eclipse.cdt.codan.core.model.IProblemLocation;
import org.eclipse.cdt.codan.core.model.IProblemLocationFactory;
import org.eclipse.cdt.codan.core.model.IProblemWorkingCopy;
import org.eclipse.cdt.codan.core.param.IProblemPreference;
import org.eclipse.cdt.codan.core.param.MapProblemPreference;
import org.eclipse.cdt.codan.core.param.RootProblemPreference;
import org.eclipse.cdt.codan.core.param.SharedRootProblemPreference;
import org.eclipse.cdt.core.ErrorParserManager;
import org.eclipse.cdt.core.IConsoleParser;
import org.eclipse.cdt.core.IMarkerGenerator;
import org.eclipse.cdt.core.ProblemMarkerInfo;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;

public abstract class AbstractExternalToolBasedChecker
extends AbstractCheckerWithProblemPreferences
implements IMarkerGenerator {
    private final IInvocationParametersProvider parametersProvider;
    private final ArgsSeparator argsSeparator;
    private final ConfigurationSettings settings;
    private final ExternalToolInvoker externalToolInvoker;
    private final RootProblemPreference preferences;

    public AbstractExternalToolBasedChecker(ConfigurationSettings settings) {
        this(new InvocationParametersProvider(), new ArgsSeparator(), settings);
    }

    public AbstractExternalToolBasedChecker(IInvocationParametersProvider parametersProvider, ArgsSeparator argsSeparator, ConfigurationSettings settings) {
        this.parametersProvider = parametersProvider;
        this.argsSeparator = argsSeparator;
        this.settings = settings;
        this.externalToolInvoker = new ExternalToolInvoker();
        this.preferences = new SharedRootProblemPreference();
    }

    public boolean runInEditor() {
        return false;
    }

    public boolean processResource(IResource resource) {
        this.process(resource);
        return false;
    }

    private void process(IResource resource) {
        try {
            InvocationParameters parameters = this.parametersProvider.createParameters(resource);
            if (parameters != null) {
                this.invokeExternalTool(parameters);
            }
        }
        catch (Throwable error) {
            this.logResourceProcessingFailure(error, resource);
        }
    }

    private void invokeExternalTool(InvocationParameters parameters) throws Throwable {
        this.updateConfigurationSettingsFromPreferences(parameters.getActualFile());
        IConsoleParser[] parsers = new IConsoleParser[]{this.createErrorParserManager(parameters)};
        try {
            this.externalToolInvoker.invoke(parameters, this.settings, this.argsSeparator, parsers);
        }
        catch (InvocationFailure error) {
            this.handleInvocationFailure(error, parameters);
        }
    }

    private void updateConfigurationSettingsFromPreferences(IResource fileToProcess) {
        IProblem problem = this.getProblemById(this.getReferenceProblemId(), fileToProcess);
        MapProblemPreference preferences = (MapProblemPreference)problem.getPreference();
        this.settings.updateValuesFrom(preferences);
    }

    private ErrorParserManager createErrorParserManager(InvocationParameters parameters) {
        IProject project = parameters.getActualFile().getProject();
        URI workingDirectory = URIUtil.toURI((IPath)parameters.getWorkingDirectory());
        return new ErrorParserManager(project, workingDirectory, (IMarkerGenerator)this, this.getParserIDs());
    }

    protected abstract String[] getParserIDs();

    protected void handleInvocationFailure(InvocationFailure error, InvocationParameters parameters) {
        this.logResourceProcessingFailure(error, parameters.getActualFile());
    }

    private void logResourceProcessingFailure(Throwable error, IResource resource) {
        String location = resource.getLocation().toOSString();
        String msg = String.format("Unable to process resource %s", location);
        Activator.log(msg, error);
    }

    protected abstract String getReferenceProblemId();

    public void initPreferences(IProblemWorkingCopy problem) {
        super.initPreferences(problem);
        this.getLaunchModePreference((IProblem)problem).enableInLaunchModes(new CheckerLaunchMode[]{CheckerLaunchMode.RUN_ON_DEMAND, CheckerLaunchMode.RUN_ON_FILE_OPEN, CheckerLaunchMode.RUN_ON_FILE_SAVE});
        this.addPreference(problem, this.settings.getPath());
        this.addPreference(problem, this.settings.getArgs());
    }

    private void addPreference(IProblemWorkingCopy problem, SingleConfigurationSetting<?> setting) {
        IProblemPreference descriptor = (IProblemPreference)setting.getDescriptor();
        this.addPreference(problem, descriptor, setting.getDefaultValue());
    }

    protected void setDefaultPreferenceValue(IProblemWorkingCopy problem, String key, Object defaultValue) {
        RootProblemPreference map = this.getTopLevelPreference((IProblem)problem);
        map.setChildValue(key, defaultValue);
    }

    public RootProblemPreference getTopLevelPreference(IProblem problem) {
        RootProblemPreference map = (RootProblemPreference)problem.getPreference();
        if (map == null) {
            map = this.preferences;
            if (problem instanceof IProblemWorkingCopy) {
                ((IProblemWorkingCopy)problem).setPreference((IProblemPreference)map);
            }
        }
        return map;
    }

    @Deprecated
    public void addMarker(IResource file, int lineNumber, String description, int severity, String variableName) {
        this.addMarker(new ProblemMarkerInfo(file, lineNumber, description, severity, variableName));
    }

    public void addMarker(ProblemMarkerInfo info) {
        this.reportProblem(this.getReferenceProblemId(), this.createProblemLocation(info), new Object[]{info.description});
    }

    protected IProblemLocation createProblemLocation(ProblemMarkerInfo info) {
        IProblemLocationFactory factory = CodanRuntime.getInstance().getProblemLocationFactory();
        return factory.createProblemLocation((IFile)info.file, info.startChar, info.endChar, info.lineNumber);
    }
}

