/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.repository;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.egit.core.Activator;
import org.eclipse.egit.core.RepositoryUtil;
import org.eclipse.egit.core.internal.SafeRunnable;
import org.eclipse.egit.core.internal.Utils;
import org.eclipse.egit.core.op.CreateLocalBranchOperation;
import org.eclipse.egit.ui.IBranchNameProvider;
import org.eclipse.egit.ui.UIUtils;
import org.eclipse.egit.ui.internal.UIIcons;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.ValidationUtils;
import org.eclipse.egit.ui.internal.branch.BranchOperationUI;
import org.eclipse.egit.ui.internal.components.BranchNameNormalizer;
import org.eclipse.egit.ui.internal.components.UpstreamConfigComponent;
import org.eclipse.egit.ui.internal.dialogs.AbstractBranchSelectionDialog;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.jgit.lib.BranchConfig;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.progress.WorkbenchJob;

class CreateBranchPage
extends WizardPage {
    private static final String BRANCH_NAME_PROVIDER_ID = "org.eclipse.egit.ui.branchNameProvider";
    private Job validateJob;
    private final Repository myRepository;
    private final IInputValidator myValidator;
    private final String myBaseRef;
    private final RevCommit myBaseCommit;
    private Text nameText;
    private boolean nameIsSuggestion;
    private Button checkout;
    private BranchConfig.BranchRebaseMode upstreamConfig;
    private UpstreamConfigComponent upstreamConfigComponent;
    private Label sourceIcon;
    private StyledText sourceNameLabel;
    private String sourceRefName = "";
    private final LocalResourceManager resourceManager = new LocalResourceManager(JFaceResources.getResources());

    public String getProposedTargetName(String sourceName) {
        if (sourceName == null) {
            return null;
        }
        if (sourceName.startsWith("refs/remotes/")) {
            return this.myRepository.shortenRemoteBranchName(sourceName);
        }
        if (sourceName.startsWith("refs/tags/")) {
            return sourceName.substring("refs/tags/".length()) + "-branch";
        }
        return "";
    }

    public CreateBranchPage(Repository repo, Ref baseRef) {
        super(CreateBranchPage.class.getName());
        this.myRepository = repo;
        this.myBaseRef = baseRef != null ? baseRef.getName() : null;
        this.myBaseCommit = null;
        this.myValidator = ValidationUtils.getRefNameInputValidator(this.myRepository, "refs/heads/", false);
        this.upstreamConfig = baseRef != null ? CreateLocalBranchOperation.getDefaultUpstreamConfig((Repository)repo, (String)baseRef.getName()) : null;
        this.setTitle(MessageFormat.format(UIText.CreateBranchPage_Title, RepositoryUtil.INSTANCE.getRepositoryName(repo)));
        this.setMessage(UIText.CreateBranchPage_ChooseBranchAndNameMessage);
    }

    public CreateBranchPage(Repository repo, RevCommit baseCommit) {
        super(CreateBranchPage.class.getName());
        this.myRepository = repo;
        this.myBaseRef = null;
        this.myBaseCommit = baseCommit;
        this.myValidator = ValidationUtils.getRefNameInputValidator(this.myRepository, "refs/heads/", false);
        this.upstreamConfig = null;
        this.setTitle(MessageFormat.format(UIText.CreateBranchPage_Title, RepositoryUtil.INSTANCE.getRepositoryName(repo)));
        this.setMessage(UIText.CreateBranchPage_ChooseNameMessage);
    }

    public void createControl(Composite parent) {
        Composite main = new Composite(parent, 0);
        main.setLayout((Layout)new GridLayout(4, false));
        Label sourceLabel = new Label(main, 0);
        sourceLabel.setText(UIText.CreateBranchPage_SourceLabel);
        sourceLabel.setToolTipText(UIText.CreateBranchPage_SourceTooltip);
        this.sourceIcon = new Label(main, 0);
        this.sourceIcon.setImage(UIIcons.getImage((ResourceManager)this.resourceManager, UIIcons.BRANCH));
        this.sourceIcon.setLayoutData((Object)GridDataFactory.fillDefaults().align(0x1000008, 0x1000000).create());
        this.sourceNameLabel = new StyledText(main, 0);
        this.sourceNameLabel.setBackground(main.getBackground());
        this.sourceNameLabel.setEditable(false);
        this.sourceNameLabel.setLayoutData((Object)GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).create());
        Button selectButton = new Button(main, 0);
        selectButton.setText(UIText.CreateBranchPage_SourceSelectButton);
        selectButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CreateBranchPage.this.selectSource();
            }
        });
        UIUtils.setButtonLayoutData(selectButton);
        Label nameLabel = new Label(main, 0);
        nameLabel.setText(UIText.CreateBranchPage_BranchNameLabel);
        nameLabel.setLayoutData((Object)GridDataFactory.fillDefaults().span(1, 1).align(1, 0x1000000).create());
        nameLabel.setToolTipText(UIText.CreateBranchPage_BranchNameToolTip);
        this.nameText = new Text(main, 2048);
        nameLabel.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                CreateBranchPage.this.nameText.setFocus();
            }
        });
        this.nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CreateBranchPage.this.nameIsSuggestion = false;
            }
        });
        this.nameText.setData("org.eclipse.swtbot.widget.key", (Object)"BranchName");
        GridDataFactory.fillDefaults().grab(true, false).span(3, 1).applyTo((Control)this.nameText);
        this.upstreamConfigComponent = new UpstreamConfigComponent(main, 0);
        GridDataFactory.fillDefaults().grab(true, false).span(4, 1).applyTo((Control)this.upstreamConfigComponent.getContainer());
        this.upstreamConfigComponent.addUpstreamConfigSelectionListener(newConfig -> {
            this.upstreamConfig = newConfig;
            this.checkPage();
        });
        boolean isBare = this.myRepository.isBare();
        this.checkout = new Button(main, 32);
        this.checkout.setText(UIText.CreateBranchPage_CheckoutButton);
        this.checkout.setSelection(!isBare);
        this.checkout.setEnabled(!isBare);
        this.checkout.setVisible(!isBare);
        GridDataFactory.fillDefaults().grab(true, false).span(3, 1).applyTo((Control)this.checkout);
        this.checkout.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CreateBranchPage.this.checkPage();
            }
        });
        this.createValidateJob();
        Dialog.applyDialogFont((Control)main);
        this.setControl((Control)main);
        if (this.myBaseCommit != null) {
            this.setSourceCommit(this.myBaseCommit);
        } else if (this.myBaseRef != null) {
            this.setSourceRef(this.myBaseRef);
        }
        this.nameText.setFocus();
        this.nameText.addModifyListener(e -> {
            this.validateJob.cancel();
            this.validateJob.schedule();
        });
        BranchNameNormalizer normalizer = new BranchNameNormalizer(this.nameText);
        normalizer.setVisible(false);
    }

    private void createValidateJob() {
        this.validateJob = new WorkbenchJob("Validate branch name"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                if (CreateBranchPage.this.sourceNameLabel.isDisposed()) {
                    return Status.CANCEL_STATUS;
                }
                CreateBranchPage.this.checkPage();
                return Status.OK_STATUS;
            }
        };
        this.validateJob.setSystem(true);
    }

    public void dispose() {
        this.resourceManager.dispose();
        if (this.validateJob != null) {
            this.validateJob.cancel();
        }
    }

    private void setSourceRef(String refName) {
        String shortName = Repository.shortenRefName((String)refName);
        this.sourceNameLabel.setText(shortName);
        if (refName.startsWith("refs/heads/") || refName.startsWith("refs/remotes/")) {
            this.sourceIcon.setImage(UIIcons.getImage((ResourceManager)this.resourceManager, UIIcons.BRANCH));
        } else if (refName.startsWith("refs/tags/")) {
            this.sourceIcon.setImage(UIIcons.getImage((ResourceManager)this.resourceManager, UIIcons.TAG));
        } else {
            this.sourceIcon.setImage(UIIcons.getImage((ResourceManager)this.resourceManager, UIIcons.CHANGESET));
        }
        this.sourceRefName = refName;
        this.suggestBranchName(refName);
        this.upstreamConfig = CreateLocalBranchOperation.getDefaultUpstreamConfig((Repository)this.myRepository, (String)refName);
        this.updateUpstreamComponent();
        this.checkPage();
    }

    private void setSourceCommit(RevCommit commit) {
        this.sourceNameLabel.setText(Utils.getShortObjectId((ObjectId)commit));
        this.sourceIcon.setImage(UIIcons.getImage((ResourceManager)this.resourceManager, UIIcons.CHANGESET));
        this.sourceRefName = commit.name();
        this.upstreamConfig = null;
        this.updateUpstreamComponent();
        this.checkPage();
    }

    private void selectSource() {
        SourceSelectionDialog dialog = new SourceSelectionDialog(this.getShell(), this.myRepository, this.sourceRefName);
        int result = dialog.open();
        if (result == 0) {
            String refName = dialog.getRefName();
            this.setSourceRef(refName);
            this.nameText.setFocus();
        }
    }

    private void updateUpstreamComponent() {
        this.upstreamConfigComponent.setUpstreamConfig(this.upstreamConfig);
        boolean showUpstreamConfig = this.sourceRefName.startsWith("refs/heads/") || this.sourceRefName.startsWith("refs/remotes/");
        Composite container = this.upstreamConfigComponent.getContainer();
        GridData gd = (GridData)container.getLayoutData();
        if (gd.exclude == showUpstreamConfig) {
            gd.exclude = !showUpstreamConfig;
            container.setVisible(showUpstreamConfig);
            container.getParent().layout(true);
            CreateBranchPage.ensurePreferredHeight(this.getShell());
        }
    }

    private void checkPage() {
        block7: {
            block6: {
                try {
                    boolean basedOnLocalBranch = this.sourceRefName.startsWith("refs/heads/");
                    if (basedOnLocalBranch && this.upstreamConfig != null) {
                        this.setMessage(UIText.CreateBranchPage_LocalBranchWarningMessage, 1);
                    } else {
                        this.setMessage(UIText.CreateBranchPage_ChooseBranchAndNameMessage);
                    }
                    if (this.sourceRefName.length() != 0) break block6;
                    this.setErrorMessage(UIText.CreateBranchPage_MissingSourceMessage);
                }
                catch (Throwable throwable) {
                    this.setPageComplete(this.getErrorMessage() == null && this.nameText.getText().length() > 0);
                    throw throwable;
                }
                this.setPageComplete(this.getErrorMessage() == null && this.nameText.getText().length() > 0);
                return;
            }
            String message = this.myValidator.isValid(this.nameText.getText());
            if (message == null) break block7;
            this.setErrorMessage(message);
            this.setPageComplete(this.getErrorMessage() == null && this.nameText.getText().length() > 0);
            return;
        }
        this.setErrorMessage(null);
        this.setPageComplete(this.getErrorMessage() == null && this.nameText.getText().length() > 0);
    }

    public String getBranchName() {
        return this.nameText.getText();
    }

    public boolean checkoutNewBranch() {
        return this.checkout.getSelection();
    }

    public void createBranch(String newRefName, boolean checkoutNewBranch, IProgressMonitor monitor) throws CoreException, IOException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(checkoutNewBranch ? 2 : 1));
        progress.setTaskName(UIText.CreateBranchPage_CreatingBranchMessage);
        CreateLocalBranchOperation cbop = this.myBaseCommit != null && this.sourceRefName.equals(this.myBaseCommit.name()) ? new CreateLocalBranchOperation(this.myRepository, newRefName, this.myBaseCommit) : new CreateLocalBranchOperation(this.myRepository, newRefName, this.myRepository.findRef(this.sourceRefName), this.upstreamConfig);
        cbop.execute((IProgressMonitor)progress.newChild(1));
        if (checkoutNewBranch && !progress.isCanceled()) {
            progress.setTaskName(UIText.CreateBranchPage_CheckingOutMessage);
            BranchOperationUI.checkout(this.myRepository, "refs/heads/" + newRefName).run((IProgressMonitor)progress.newChild(1));
        }
    }

    private void suggestBranchName(String ref) {
        if (this.nameText.getText().length() == 0 || this.nameIsSuggestion) {
            String branchNameSuggestion = this.getBranchNameSuggestionFromProvider();
            if (branchNameSuggestion == null) {
                branchNameSuggestion = this.getProposedTargetName(ref);
            }
            if (branchNameSuggestion != null) {
                this.nameText.setText(branchNameSuggestion);
                this.nameText.selectAll();
                this.nameIsSuggestion = true;
            }
        }
    }

    private IBranchNameProvider getBranchNameProvider() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] config = registry.getConfigurationElementsFor(BRANCH_NAME_PROVIDER_ID);
        if (config.length > 0) {
            try {
                Object provider = config[0].createExecutableExtension("class");
                if (provider instanceof IBranchNameProvider) {
                    return (IBranchNameProvider)provider;
                }
            }
            catch (Throwable e) {
                Activator.logError((String)UIText.CreateBranchPage_CreateBranchNameProviderFailed, (Throwable)e);
            }
        }
        return null;
    }

    private String getBranchNameSuggestionFromProvider() {
        AtomicReference ref = new AtomicReference();
        IBranchNameProvider branchNameProvider = this.getBranchNameProvider();
        if (branchNameProvider != null) {
            SafeRunnable.run(() -> ref.set(branchNameProvider.getBranchNameSuggestion()));
        }
        return (String)ref.get();
    }

    private static void ensurePreferredHeight(Shell shell) {
        int preferredHeight = shell.computeSize((int)-1, (int)-1).y;
        Point size = shell.getSize();
        if (size.y < preferredHeight) {
            shell.setSize(size.x, preferredHeight);
        }
    }

    private static class SourceSelectionDialog
    extends AbstractBranchSelectionDialog {
        public SourceSelectionDialog(Shell parentShell, Repository repository, String refToMark) {
            super(parentShell, repository, refToMark, 254);
        }

        @Override
        protected void refNameSelected(String refName) {
            this.setOkButtonEnabled(refName != null);
        }

        @Override
        protected String getTitle() {
            return UIText.CreateBranchPage_SourceSelectionDialogTitle;
        }

        @Override
        protected String getMessageText() {
            return UIText.CreateBranchPage_SourceSelectionDialogMessage;
        }
    }
}

