/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.linuxtools.docker.core.IDockerNetworkSettings;
import org.eclipse.linuxtools.docker.core.IDockerPortBinding;
import org.eclipse.linuxtools.internal.docker.core.DockerPortBinding;
import org.mandas.docker.client.messages.NetworkSettings;
import org.mandas.docker.client.messages.PortBinding;

public class DockerNetworkSettings
implements IDockerNetworkSettings {
    private final String bridge;
    private final String gateway;
    private final String ipAddress;
    private final Integer ipPrefixLen;
    private final Map<String, Map<String, String>> portMapping;
    private final Map<String, List<IDockerPortBinding>> ports;

    public DockerNetworkSettings(NetworkSettings networkSettings) {
        this.bridge = networkSettings.bridge();
        this.gateway = networkSettings.gateway();
        this.ipAddress = networkSettings.ipAddress();
        this.ipPrefixLen = networkSettings.ipPrefixLen();
        this.portMapping = networkSettings.portMapping();
        this.ports = new HashMap<String, List<IDockerPortBinding>>();
        if (networkSettings.ports() != null) {
            for (Map.Entry entry : networkSettings.ports().entrySet()) {
                ArrayList<DockerPortBinding> values = new ArrayList<DockerPortBinding>();
                if (entry.getValue() != null) {
                    for (PortBinding portBinding : (List)entry.getValue()) {
                        values.add(new DockerPortBinding(portBinding));
                    }
                }
                this.ports.put((String)entry.getKey(), values);
            }
        }
    }

    @Override
    public String bridge() {
        return this.bridge;
    }

    @Override
    public String gateway() {
        return this.gateway;
    }

    @Override
    public String ipAddress() {
        return this.ipAddress;
    }

    @Override
    public Integer ipPrefixLen() {
        return this.ipPrefixLen;
    }

    @Override
    public Map<String, Map<String, String>> portMapping() {
        return this.portMapping;
    }

    @Override
    public Map<String, List<IDockerPortBinding>> ports() {
        return this.ports;
    }
}

