/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui.newui;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.internal.ui.newui.Messages;
import org.eclipse.cdt.ui.newui.CDTPrefUtil;
import org.eclipse.cdt.ui.newui.ICPropertyProvider;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PreferencesUtil;

public class StringListModeControl {
    private static final String STRING_LIST_MODE_PREFERENCE_PAGE = "org.eclipse.cdt.managedbuilder.ui.preferences.PrefPage_MultiConfig";
    private ICPropertyProvider page;
    private Link linkStringListMode;
    private List<Listener> listeners = new ArrayList<Listener>();

    public StringListModeControl(ICPropertyProvider page, final Composite parent, int span) {
        this.page = page;
        this.linkStringListMode = new Link(parent, 0);
        this.updateStringListModeLink(this.linkStringListMode);
        this.linkStringListMode.setToolTipText(Messages.AbstractLangsListTab_MultiConfigStringListModeLinkHint);
        this.linkStringListMode.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                int result = PreferencesUtil.createPreferenceDialogOn((Shell)parent.getShell(), (String)StringListModeControl.STRING_LIST_MODE_PREFERENCE_PAGE, null, null).open();
                if (result != 1) {
                    StringListModeControl.this.updateStringListModeControl();
                    for (Listener listener : StringListModeControl.this.listeners) {
                        listener.handleEvent(event);
                    }
                }
            }
        });
        GridData gridData = new GridData(131072, 0, true, false);
        gridData.horizontalSpan = span;
        this.linkStringListMode.setLayoutData((Object)gridData);
    }

    public void addListener(int eventType, Listener listener) {
        this.listeners.add(listener);
    }

    protected void removeListener(int eventType, Listener listener) {
        this.listeners.remove(listener);
    }

    public void updateStringListModeControl() {
        this.updateStringListModeLink(this.linkStringListMode);
    }

    private void updateStringListModeLink(Link link) {
        boolean isMultiCfg = this.page.isMultiCfg();
        this.linkStringListMode.setVisible(isMultiCfg);
        if (isMultiCfg) {
            String modeUnknown;
            String modeDisplay = modeUnknown = Messages.AbstractLangsListTab_UnknownMode;
            switch (CDTPrefUtil.getMultiCfgStringListDisplayMode()) {
                case 1: {
                    modeDisplay = Messages.AbstractLangsListTab_Conjunction;
                    break;
                }
                case 2: {
                    modeDisplay = Messages.AbstractLangsListTab_Disjunction;
                }
            }
            String modeWrite = modeUnknown;
            switch (CDTPrefUtil.getMultiCfgStringListWriteMode()) {
                case 4: {
                    modeWrite = Messages.AbstractLangsListTab_Modify;
                    break;
                }
                case 8: {
                    modeWrite = Messages.AbstractLangsListTab_Replace;
                }
            }
            this.linkStringListMode.setText(Messages.AbstractLangsListTab_StringListMode + " <a href=\"workspace-settings\">" + modeDisplay + "</a> + <a href=\"workspace-settings\">" + modeWrite + "</a>");
        }
        this.linkStringListMode.getParent().layout();
    }
}

