/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.binutils.link2source;

import java.io.File;
import java.net.URI;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.cdt.core.IBinaryParser;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IOutputEntry;
import org.eclipse.cdt.core.model.ISourceRoot;
import org.eclipse.cdt.debug.core.CDebugCorePlugin;
import org.eclipse.cdt.debug.internal.core.sourcelookup.CSourceLookupDirector;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.sourcelookup.ISourceContainer;
import org.eclipse.debug.core.sourcelookup.containers.LocalFileStorage;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.linuxtools.binutils.link2source.STCSourceNotFoundEditorInput;
import org.eclipse.linuxtools.binutils.utils.STSymbolManager;
import org.eclipse.linuxtools.internal.Activator;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public final class STLink2SourceSupport {
    private STLink2SourceSupport() {
    }

    private static boolean openSourceFileAtLocation(IPath binaryLoc, IPath sourceLoc, int lineNumber) {
        IFile binary = STSymbolManager.sharedInstance.findFileFromPath(binaryLoc);
        IProject project = null;
        if (binary != null) {
            project = binary.getProject();
        }
        return STLink2SourceSupport.openFileImpl(project, sourceLoc, lineNumber);
    }

    public static boolean openSourceFileAtLocation(IProject project, IPath sourceLoc, int lineNumber) {
        return STLink2SourceSupport.openFileImpl(project, sourceLoc, lineNumber);
    }

    public static boolean openSourceFileAtLocation(IBinaryParser.IBinaryObject binary, String sourceLoc, int lineNumber) {
        if (sourceLoc == null) {
            return false;
        }
        Path p = new Path(sourceLoc);
        return STLink2SourceSupport.openSourceFileAtLocation(binary.getPath(), (IPath)p, lineNumber);
    }

    private static boolean openFileImpl(IProject project, IPath sourceLoc, int lineNumber) {
        if (sourceLoc == null || "??".equals(sourceLoc.toString())) {
            return false;
        }
        try {
            IEditorInput editorInput = STLink2SourceSupport.getEditorInput(sourceLoc, project);
            IWorkbenchPage p = CUIPlugin.getActivePage();
            if (p != null) {
                if (editorInput == null) {
                    p.openEditor((IEditorInput)new STCSourceNotFoundEditorInput(project, sourceLoc, lineNumber), "org.eclipse.linuxtools.binutils.link2source.STCSourceNotFoundEditor", true);
                } else {
                    IEditorPart editor = p.openEditor(editorInput, "org.eclipse.cdt.ui.editor.CEditor", true);
                    if (lineNumber > 0 && editor instanceof ITextEditor) {
                        ITextEditor textEditor = (ITextEditor)editor;
                        IDocumentProvider provider = textEditor.getDocumentProvider();
                        IDocument document = provider.getDocument((Object)editor.getEditorInput());
                        try {
                            int start = document.getLineOffset(lineNumber - 1);
                            textEditor.selectAndReveal(start, 0);
                            IWorkbenchPage page = editor.getSite().getPage();
                            page.activate((IWorkbenchPart)editor);
                            return true;
                        }
                        catch (BadLocationException badLocationException) {}
                    }
                }
            }
        }
        catch (PartInitException partInitException) {
            // empty catch block
        }
        return false;
    }

    public static IEditorInput getEditorInput(IPath p, IProject project) {
        File file;
        IFile f = STLink2SourceSupport.getFileForPath(p, project);
        if (f != null && f.exists()) {
            return new FileEditorInput(f);
        }
        if (p.isAbsolute() && (file = p.toFile()).exists()) {
            try {
                IFileStore ifs = EFS.getStore((URI)file.toURI());
                return new FileStoreEditorInput(ifs);
            }
            catch (CoreException e) {
                Activator.getDefault().getLog().log(e.getStatus());
            }
        }
        return STLink2SourceSupport.findFileInCommonSourceLookup(p);
    }

    private static IEditorInput findFileInCommonSourceLookup(IPath path) {
        try {
            ISourceContainer[] c;
            CSourceLookupDirector director = CDebugCorePlugin.getDefault().getCommonSourceLookupDirector();
            for (ISourceContainer sourceContainer : c = director.getSourceContainers()) {
                Object[] o;
                for (Object object : o = sourceContainer.findSourceElements(path.toOSString())) {
                    if (object instanceof IFile) {
                        IFile file = (IFile)object;
                        return new FileEditorInput(file);
                    }
                    if (!(object instanceof LocalFileStorage)) continue;
                    LocalFileStorage storage = (LocalFileStorage)object;
                    IFileStore ifs = EFS.getStore((URI)storage.getFile().toURI());
                    return new FileStoreEditorInput(ifs);
                }
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return null;
    }

    public static IFile getFileForPath(IPath path, IProject project) {
        IFile f;
        block4: {
            f = STLink2SourceSupport.getFileForPathImpl(path, project);
            if (f != null) break block4;
            HashSet<IProject> allProjects = new HashSet<IProject>();
            try {
                STLink2SourceSupport.getAllReferencedProjects(allProjects, project);
            }
            catch (CoreException e) {
                Activator.getDefault().getLog().log(e.getStatus());
            }
            if (allProjects != null) {
                IProject project2;
                Iterator iterator = allProjects.iterator();
                while (iterator.hasNext() && (f = STLink2SourceSupport.getFileForPathImpl(path, project2 = (IProject)iterator.next())) == null) {
                }
            }
        }
        return f;
    }

    private static IFile getFileForPathImpl(IPath path, IProject project) {
        ICProject cproject;
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        if (path.isAbsolute()) {
            return STSymbolManager.sharedInstance.findFileFromPath(path);
        }
        if (project != null && project.exists() && (cproject = CoreModel.getDefault().create(project)) != null) {
            try {
                IOutputEntry[] entries;
                ISourceRoot[] roots;
                for (ISourceRoot sourceRoot : roots = cproject.getAllSourceRoots()) {
                    IContainer r = sourceRoot.getResource();
                    IResource res = r.findMember(path);
                    if (res == null || !res.exists() || !(res instanceof IFile)) continue;
                    IFile file = (IFile)res;
                    return file;
                }
                for (IOutputEntry pathEntry : entries = cproject.getOutputEntries()) {
                    IContainer parent;
                    IResource res;
                    IPath p = pathEntry.getPath();
                    IResource r = root.findMember(p);
                    if (!(r instanceof IContainer) || (res = (parent = (IContainer)r).findMember(path)) == null || !res.exists() || !(res instanceof IFile)) continue;
                    IFile file = (IFile)res;
                    return file;
                }
            }
            catch (CModelException e) {
                Activator.getDefault().getLog().log(e.getStatus());
            }
        }
        IPath realPath = project.getLocation().append(path).makeAbsolute();
        URI realURI = URIUtil.toURI((String)realPath.toString());
        try {
            FindLinkedResourceVisitor visitor = new FindLinkedResourceVisitor(realURI);
            project.accept((IResourceProxyVisitor)visitor, 2);
            if (visitor.foundElement()) {
                return (IFile)visitor.getResource();
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return null;
    }

    private static void getAllReferencedProjects(Set<IProject> all, IProject project) throws CoreException {
        if (project != null) {
            IProject[] refs;
            for (IProject ref : refs = project.getReferencedProjects()) {
                if (all.contains(ref) || !ref.exists() || !ref.isOpen()) continue;
                all.add(ref);
                STLink2SourceSupport.getAllReferencedProjects(all, ref);
            }
        }
    }

    private static class FindLinkedResourceVisitor
    implements IResourceProxyVisitor {
        private final URI element;
        private boolean keepSearching = true;
        private boolean found;
        private IResource resource;
        private String lastLinkPath;

        public FindLinkedResourceVisitor(URI element) {
            this.element = element;
        }

        public boolean foundElement() {
            return this.found;
        }

        public IResource getResource() {
            return this.resource;
        }

        public boolean visit(IResourceProxy proxy) {
            if (proxy.isLinked()) {
                this.lastLinkPath = proxy.requestFullPath().toString();
            }
            if (this.lastLinkPath != null && proxy.requestFullPath().toString().startsWith(this.lastLinkPath) && proxy.requestResource().getLocationURI().equals(this.element)) {
                this.found = true;
                this.resource = proxy.requestResource();
                this.keepSearching = false;
            }
            return this.keepSearching;
        }
    }
}

