/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.ui;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;
import org.eclipse.wst.sse.core.internal.IExecutionDelegate;
import org.eclipse.wst.sse.ui.StructuredTextEditor;
import org.eclipse.wst.sse.ui.internal.Logger;
import org.eclipse.wst.sse.ui.internal.SSEUIPlugin;

class EditorExecutionContext
implements IExecutionDelegate {
    StructuredTextEditor fTextEditor;
    IEditorPart fEditorPart = null;
    private ReusableUIRunner fReusableRunner;

    public EditorExecutionContext(IEditorPart editorPart, StructuredTextEditor editor) {
        this.fEditorPart = editorPart;
        this.fTextEditor = editor;
        this.fReusableRunner = new ReusableUIRunner(this.fEditorPart, this.fTextEditor);
    }

    public void execute(ISafeRunnable runnable) {
        IWorkbench workbench = SSEUIPlugin.getInstance().getWorkbench();
        Display display = workbench.getDisplay();
        if (display.getThread() == Thread.currentThread()) {
            SafeRunner.run((ISafeRunnable)runnable);
        } else {
            this.fReusableRunner.setRunnable(runnable);
            display.syncExec((Runnable)this.fReusableRunner);
        }
    }

    private static class ReusableUIRunner
    implements Runnable,
    IRunnableWithProgress {
        private StructuredTextEditor textEditor;
        private IEditorPart editorPart = null;
        private ISafeRunnable fRunnable = null;

        ReusableUIRunner(IEditorPart editorPart, StructuredTextEditor textEditor) {
            this.textEditor = textEditor;
            this.editorPart = editorPart;
        }

        @Override
        public void run() {
            IWorkbenchSiteProgressService jobService;
            IWorkbenchPartSite site = this.editorPart.getSite();
            IWorkbenchWindow workbenchWindow = site == null ? null : site.getWorkbenchWindow();
            IWorkbenchSiteProgressService iWorkbenchSiteProgressService = jobService = site == null ? null : (IWorkbenchSiteProgressService)site.getAdapter(IWorkbenchSiteProgressService.class);
            if (workbenchWindow != null && jobService != null) {
                try {
                    jobService.runInUI((IRunnableContext)workbenchWindow, (IRunnableWithProgress)this, (ISchedulingRule)this.editorPart.getEditorInput().getAdapter(IResource.class));
                }
                catch (InvocationTargetException e) {
                    Logger.logException(e);
                }
                catch (InterruptedException e) {
                    Logger.logException(e);
                }
            } else {
                IWorkbench workbench = SSEUIPlugin.getInstance().getWorkbench();
                Display display = workbench.getDisplay();
                if (display != null && !display.isDisposed()) {
                    if (this.textEditor != null) {
                        this.textEditor.beginBackgroundOperation();
                    }
                    try {
                        SafeRunner.run((ISafeRunnable)this.fRunnable);
                    }
                    finally {
                        if (this.textEditor != null) {
                            this.textEditor.endBackgroundOperation();
                        }
                    }
                }
                this.fRunnable = null;
            }
        }

        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            if (this.fRunnable != null) {
                SafeRunner.run((ISafeRunnable)this.fRunnable);
            }
        }

        void setRunnable(ISafeRunnable r) {
            this.fRunnable = r;
        }
    }
}

