/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.valgrind.ui.quickfixes;

import org.eclipse.cdt.codan.ui.AbstractCodanCMarkerResolution;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTNodeSelector;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;

public abstract class AbstractValgrindMarkerResolution
extends AbstractCodanCMarkerResolution {
    protected IASTNode getIASTNode(IMarker marker, IDocument document) {
        int offset = this.getOffset(marker, document);
        int length = this.getLength(marker, document);
        IASTNode node = null;
        IASTTranslationUnit ast = this.getASTTranslationUnit(marker);
        IASTNodeSelector nodeSelector = ast.getNodeSelector(marker.getResource().getLocationURI().getPath());
        node = nodeSelector.findFirstContainedNode(offset, length);
        return node;
    }

    private IASTTranslationUnit getASTTranslationUnit(IMarker marker) {
        ITranslationUnit tu = this.getTranslationUnitViaEditor(marker);
        try {
            return tu.getAST();
        }
        catch (CoreException e) {
            return null;
        }
    }

    private int getLength(IMarker marker, IDocument document) {
        int charStart = marker.getAttribute("charStart", -1);
        int charEnd = marker.getAttribute("charEnd", -1);
        if (charEnd != -1 && charStart != -1) {
            return charEnd - charStart;
        }
        int line = marker.getAttribute("lineNumber", -1) - 1;
        try {
            return document.getLineLength(line);
        }
        catch (BadLocationException e) {
            return -1;
        }
    }
}

