/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.importing;

import java.net.URI;
import org.eclipse.egit.core.internal.GitURI;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.SWTUtils;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Table;
import org.eclipse.team.core.ScmUrlImportDescription;
import org.eclipse.team.ui.IScmUrlImportWizardPage;
import org.eclipse.ui.PlatformUI;

public class GitScmUrlImportWizardPage
extends WizardPage
implements IScmUrlImportWizardPage {
    private ScmUrlImportDescription[] descriptions;
    private Label counterLabel;
    private TableViewer bundlesViewer;
    private Button useMaster;
    private static final String GIT_PAGE_USE_MASTER = "org.eclipse.team.egit.ui.import.page.master";

    public GitScmUrlImportWizardPage() {
        super("git", UIText.GitScmUrlImportWizardPage_title, null);
        this.setDescription(UIText.GitScmUrlImportWizardPage_description);
    }

    public void createControl(Composite parent) {
        Composite comp = SWTUtils.createHVFillComposite(parent, 0, 1);
        Composite group = SWTUtils.createHFillComposite(comp, 0, 1);
        Button versions = SWTUtils.createRadioButton(group, UIText.GitScmUrlImportWizardPage_importVersion);
        this.useMaster = SWTUtils.createRadioButton(group, UIText.GitScmUrlImportWizardPage_importMaster);
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GitScmUrlImportWizardPage.this.bundlesViewer.refresh(true);
            }
        };
        versions.addSelectionListener((SelectionListener)listener);
        this.useMaster.addSelectionListener((SelectionListener)listener);
        Table table = new Table(comp, 2562);
        GridData gd = new GridData(1808);
        gd.heightHint = 200;
        gd.widthHint = 225;
        table.setLayoutData((Object)gd);
        this.bundlesViewer = new TableViewer(table);
        this.bundlesViewer.setLabelProvider((IBaseLabelProvider)new GitLabelProvider());
        this.bundlesViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.bundlesViewer.setComparator(new ViewerComparator());
        this.counterLabel = new Label(comp, 0);
        this.counterLabel.setLayoutData((Object)new GridData(768));
        this.setControl((Control)comp);
        this.setPageComplete(true);
        IDialogSettings settings = this.getWizard().getDialogSettings();
        boolean useMasterSetting = settings != null && settings.getBoolean(GIT_PAGE_USE_MASTER);
        this.useMaster.setSelection(useMasterSetting);
        versions.setSelection(!useMasterSetting);
        if (this.descriptions != null) {
            this.bundlesViewer.setInput((Object)this.descriptions);
            this.updateCount();
        }
    }

    public boolean finish() {
        boolean head = false;
        if (this.getControl() != null) {
            head = this.useMaster.getSelection();
            settings = this.getWizard().getDialogSettings();
            if (settings != null) {
                settings.put(GIT_PAGE_USE_MASTER, head);
            }
        } else {
            settings = this.getWizard().getDialogSettings();
            if (settings != null) {
                head = settings.getBoolean(GIT_PAGE_USE_MASTER);
            }
        }
        if (head && this.descriptions != null) {
            ScmUrlImportDescription[] scmUrlImportDescriptionArray = this.descriptions;
            int n = this.descriptions.length;
            int n2 = 0;
            while (n2 < n) {
                ScmUrlImportDescription description = scmUrlImportDescriptionArray[n2];
                URI scmUri = description.getUri();
                description.setUrl(GitScmUrlImportWizardPage.removeTag(scmUri));
                ++n2;
            }
        }
        return true;
    }

    public ScmUrlImportDescription[] getSelection() {
        return this.descriptions;
    }

    public void setSelection(ScmUrlImportDescription[] descriptions) {
        this.descriptions = descriptions;
        if (this.bundlesViewer != null) {
            this.bundlesViewer.setInput((Object)descriptions);
            this.updateCount();
        }
    }

    private void updateCount() {
        this.counterLabel.setText(NLS.bind((String)UIText.GitScmUrlImportWizardPage_counter, (Object)this.descriptions.length));
        this.counterLabel.getParent().layout();
    }

    private static String getTag(URI scmUri) {
        GitURI gitURI = new GitURI(scmUri);
        return gitURI.getTag();
    }

    private static String removeTag(URI scmUri) {
        StringBuilder sb = new StringBuilder();
        sb.append(scmUri.getScheme()).append(':');
        String ssp = scmUri.getSchemeSpecificPart();
        int j = ssp.indexOf(59);
        if (j != -1) {
            String[] params;
            sb.append(ssp.substring(0, j));
            String[] stringArray = params = ssp.substring(j).split(";");
            int n = params.length;
            int n2 = 0;
            while (n2 < n) {
                String param = stringArray[n2];
                if (!(param.startsWith("tag=") || param.startsWith("version=") || param.isEmpty())) {
                    sb.append(";").append(param);
                }
                ++n2;
            }
        } else {
            sb.append(ssp);
        }
        return sb.toString();
    }

    private static String getServer(URI scmUri) {
        GitURI gitURI = new GitURI(scmUri);
        return gitURI.getRepository().toString();
    }

    static class GitLabelProvider
    extends StyledCellLabelProvider
    implements ILabelProvider {
        GitLabelProvider() {
        }

        public Image getImage(Object element) {
            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_PROJECT");
        }

        public String getText(Object element) {
            return this.getStyledText(element).getString();
        }

        public void update(ViewerCell cell) {
            StyledString string = this.getStyledText(cell.getElement());
            cell.setText(string.getString());
            cell.setStyleRanges(string.getStyleRanges());
            cell.setImage(this.getImage(cell.getElement()));
            super.update(cell);
        }

        private StyledString getStyledText(Object element) {
            StyledString styledString = new StyledString();
            if (element instanceof ScmUrlImportDescription) {
                ScmUrlImportDescription description = (ScmUrlImportDescription)element;
                String project = description.getProject();
                URI scmUrl = description.getUri();
                try {
                    String version = GitScmUrlImportWizardPage.getTag(scmUrl);
                    String host = GitScmUrlImportWizardPage.getServer(scmUrl);
                    styledString.append(project);
                    if (version != null) {
                        styledString.append(' ');
                        styledString.append(version, StyledString.DECORATIONS_STYLER);
                    }
                    styledString.append(' ');
                    styledString.append('[', StyledString.DECORATIONS_STYLER);
                    styledString.append(host, StyledString.DECORATIONS_STYLER);
                    styledString.append(']', StyledString.DECORATIONS_STYLER);
                }
                catch (IllegalArgumentException e) {
                    styledString.append(e.getMessage());
                    Activator.logError(e.getMessage(), e);
                }
                return styledString;
            }
            styledString.append(element.toString());
            return styledString;
        }
    }
}

