/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.findandreplace.overlay;

import java.time.Duration;
import java.util.Objects;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.notifications.NotificationPopup;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.findandreplace.FindReplaceMessages;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class FindReplaceOverlayFirstTimePopup {
    private static final String PREFERENCE_NODE_NAME = "org.eclipse.ui.editors";
    private static final String SETTING_POPUP_WAS_SHOWN_BEFORE = "hasShownOverlayPopupBefore";
    private static final Duration POPUP_VANISH_TIME = Duration.ofSeconds(6L);
    private static final String USE_FIND_REPLACE_OVERLAY = "useFindReplaceOverlay";

    private FindReplaceOverlayFirstTimePopup() {
    }

    private static IDialogSettings getDialogSettings() {
        IDialogSettings settings = PlatformUI.getDialogSettingsProvider((Bundle)FrameworkUtil.getBundle(FindReplaceOverlayFirstTimePopup.class)).getDialogSettings();
        return settings;
    }

    private static void disableUseOverlayPreference() {
        IEclipsePreferences preferences = InstanceScope.INSTANCE.getNode(PREFERENCE_NODE_NAME);
        preferences.putBoolean(USE_FIND_REPLACE_OVERLAY, false);
    }

    public static void displayPopupIfNotAlreadyShown(Shell shellToUse) {
        IDialogSettings settings = FindReplaceOverlayFirstTimePopup.getDialogSettings();
        if (!settings.getBoolean(SETTING_POPUP_WAS_SHOWN_BEFORE)) {
            settings.put(SETTING_POPUP_WAS_SHOWN_BEFORE, true);
            Display displayToUse = Objects.nonNull(shellToUse) ? shellToUse.getDisplay() : Display.getDefault();
            NotificationPopup.forDisplay((Display)displayToUse).content(t -> FindReplaceOverlayFirstTimePopup.createFirstTimeNotification(t)).title(FindReplaceMessages.FindReplaceOverlayFirstTimePopup_FindReplaceOverlayFirstTimePopup_title, true).delay(POPUP_VANISH_TIME.toMillis()).open();
        }
    }

    private static Control createFirstTimeNotification(Composite composite) {
        Link messageBody = new Link(composite, 64);
        messageBody.setText(FindReplaceMessages.FindReplaceOverlayFirstTimePopup_FindReplaceOverlayFirstTimePopup_message);
        messageBody.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        messageBody.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            FindReplaceOverlayFirstTimePopup.disableUseOverlayPreference();
            composite.getShell().close();
        }));
        return messageBody;
    }
}

