/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.internal.core.makefile;

public class Util {
    private Util() {
    }

    public static boolean isCommand(String line) {
        return line.length() > 1 && line.startsWith("\t");
    }

    public static boolean isEscapedLine(String line) {
        return line.endsWith("\\") && !line.endsWith("\\\\");
    }

    public static boolean isEmptyLine(String line) {
        return line.trim().length() == 0;
    }

    public static int indexOfComment(String line) {
        boolean escaped = false;
        int i = 0;
        while (i < line.length()) {
            if (line.charAt(i) == '#' && !escaped) {
                return i;
            }
            escaped = line.charAt(i) == '\\';
            ++i;
        }
        return -1;
    }

    public static boolean isSpace(char c) {
        return c == ' ' || c == '\t' || c == '\r' || c == '\n';
    }

    public static int indexOf(String line, char c) {
        return Util.indexOf(line, String.valueOf(c));
    }

    public static int indexOf(String line, String tokens) {
        int paren = 0;
        int bracket = 0;
        int prev = 0;
        int pprev = 0;
        int i = 0;
        while (i < line.length()) {
            char ch = line.charAt(i);
            if (ch == '(' && prev == 36 && pprev != 92) {
                ++paren;
            } else if (ch == '{' && prev == 36 && pprev != 92) {
                ++bracket;
            } else if (ch == ')' && prev != 92) {
                if (paren > 0) {
                    --paren;
                }
            } else if (ch == '}' && prev != 92) {
                if (bracket > 0) {
                    --bracket;
                }
            } else if (tokens.indexOf(ch) != -1 && paren == 0 && bracket == 0) {
                return i;
            }
            pprev = prev;
            prev = ch;
            ++i;
        }
        return -1;
    }
}

