/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.internal.builder.plexusbuildapi;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.plexus.util.AbstractScanner;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.m2e.core.internal.builder.plexusbuildapi.EclipseIncrementalBuildContext;

public class ResourceDeltaScanner
extends AbstractScanner {
    protected final IResourceDelta delta;
    protected final List<String> includedDirectories = new ArrayList<String>();
    protected final List<String> includedFiles = new ArrayList<String>();
    protected final boolean deleted;

    public ResourceDeltaScanner(IResourceDelta delta, boolean deleted) {
        this.delta = delta;
        this.deleted = deleted;
    }

    public String[] getIncludedDirectories() {
        return this.includedDirectories.toArray(new String[this.includedDirectories.size()]);
    }

    public String[] getIncludedFiles() {
        return this.includedFiles.toArray(new String[this.includedFiles.size()]);
    }

    public void scan() {
        try {
            this.setupDefaultFilters();
            this.setupMatchPatterns();
            this.scanDelta();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    private void scanDelta() throws CoreException {
        this.delta.accept(new IResourceDeltaVisitor(){

            public boolean visit(IResourceDelta delta) {
                String relpath = ResourceDeltaScanner.this.getRelativePath(delta);
                if (ResourceDeltaScanner.this.isInteresting(delta) && ResourceDeltaScanner.this.isIncluded(relpath) && !ResourceDeltaScanner.this.isExcluded(relpath)) {
                    IResource resource = delta.getResource();
                    if (resource instanceof IContainer) {
                        ResourceDeltaScanner.this.includedDirectories.add(relpath);
                    } else {
                        ResourceDeltaScanner.this.includedFiles.add(relpath);
                    }
                    return true;
                }
                if (delta.getResource() instanceof IContainer) {
                    return ResourceDeltaScanner.this.couldHoldIncluded(relpath);
                }
                return false;
            }
        });
    }

    protected boolean isInteresting(IResourceDelta delta) {
        return this.deleted ? EclipseIncrementalBuildContext.isRemove(delta) : EclipseIncrementalBuildContext.isContentChange(delta);
    }

    protected String getRelativePath(IResourceDelta delta) {
        return delta.getFullPath().removeFirstSegments(this.delta.getFullPath().segmentCount()).toOSString();
    }

    public File getBasedir() {
        return this.delta.getResource().getLocation().toFile();
    }
}

