/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.terminal.internal.textcanvas;

import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.terminal.internal.textcanvas.VirtualCanvas;

public abstract class GridCanvas
extends VirtualCanvas {
    private int fCellWidth;
    private int fCellHeight;

    public GridCanvas(Composite parent, int style) {
        super(parent, style);
        this.addListener(37, event -> {
            if (this.getVerticalBar().isVisible()) {
                int delta = -this.fCellHeight * event.count;
                this.scrollYDelta(delta);
            }
            event.doit = false;
        });
    }

    @Override
    protected void paint(GC gc) {
        int rowLast;
        Rectangle clipping = gc.getClipping();
        if (clipping.width == 0 || clipping.height == 0) {
            return;
        }
        Rectangle clientArea = this.getScreenRectInVirtualSpace();
        int xOffset = clientArea.x;
        int yOffset = clientArea.y;
        int colFirst = this.virtualXToCell(xOffset + clipping.x);
        if (colFirst > this.getCols()) {
            colFirst = this.getCols();
        } else if (colFirst < 0) {
            colFirst = 0;
        }
        int rowFirst = this.virtualYToCell(yOffset + clipping.y);
        int colLast = this.virtualXToCell(xOffset + clipping.x + clipping.width + this.fCellWidth);
        if (colLast > this.getCols()) {
            colLast = this.getCols();
        }
        if ((rowLast = this.virtualYToCell(yOffset + clipping.y + clipping.height + this.fCellHeight)) > this.getRows()) {
            rowLast = this.getRows();
        }
        int row = rowFirst;
        while (row <= rowLast) {
            int cx = colFirst * this.fCellWidth - xOffset;
            int cy = row * this.fCellHeight - yOffset;
            this.drawLine(gc, row, cx, cy, colFirst, colLast);
            ++row;
        }
        this.paintUnoccupiedSpace(gc, clipping);
    }

    abstract void drawLine(GC var1, int var2, int var3, int var4, int var5, int var6);

    protected abstract int getRows();

    protected abstract int getCols();

    protected void setCellWidth(int cellWidth) {
        this.fCellWidth = cellWidth;
        this.getHorizontalBar().setIncrement(this.fCellWidth);
    }

    public int getCellWidth() {
        return this.fCellWidth;
    }

    protected void setCellHeight(int cellHeight) {
        this.fCellHeight = cellHeight;
        this.getVerticalBar().setIncrement(this.fCellHeight);
    }

    public int getCellHeight() {
        return this.fCellHeight;
    }

    int virtualXToCell(int x) {
        return x / this.fCellWidth;
    }

    int virtualYToCell(int y) {
        return y / this.fCellHeight;
    }

    protected Point screenPointToCell(int x, int y) {
        x = this.screenXtoVirtual(x) / this.fCellWidth;
        y = this.screenYtoVirtual(y) / this.fCellHeight;
        return new Point(x, y);
    }

    Point screenPointToCell(Point point) {
        return this.screenPointToCell(point.x, point.y);
    }

    protected Point cellToOriginOnScreen(int x, int y) {
        x = this.virtualXtoScreen(this.fCellWidth * x);
        y = this.virtualYtoScreen(this.fCellHeight * y);
        return new Point(x, y);
    }

    Point cellToOriginOnScreen(Point cell) {
        return this.cellToOriginOnScreen(cell.x, cell.y);
    }

    Rectangle getCellScreenRect(Point cell) {
        return this.getCellScreenRect(cell.x, cell.y);
    }

    Rectangle getCellScreenRect(int x, int y) {
        x = this.fCellWidth * this.virtualXtoScreen(x);
        y = this.fCellHeight * this.virtualYtoScreen(y);
        return new Rectangle(x, y, this.fCellWidth, this.fCellHeight);
    }

    protected Rectangle getCellVirtualRect(Point cell) {
        return this.getCellVirtualRect(cell.x, cell.y);
    }

    Rectangle getCellVirtualRect(int x, int y) {
        x = this.fCellWidth * x;
        y = this.fCellHeight * y;
        return new Rectangle(x, y, this.fCellWidth, this.fCellHeight);
    }

    @Override
    protected void viewRectangleChanged(int x, int y, int width, int height) {
        int cellX = this.virtualXToCell(x);
        int cellY = this.virtualYToCell(y);
        int xE = this.virtualXToCell(x + width);
        int yE = this.virtualYToCell(y + height);
        this.visibleCellRectangleChanged(cellX, cellY, xE - cellX, yE - cellY);
    }

    protected void visibleCellRectangleChanged(int x, int y, int width, int height) {
    }

    @Override
    protected void setVirtualExtend(int width, int height) {
        int cellHeight = this.getCellHeight();
        if (cellHeight > 0) {
            height -= height % cellHeight;
        }
        super.setVirtualExtend(width, height);
    }

    @Override
    protected void setVirtualOrigin(int x, int y) {
        int cellHeight = this.getCellHeight();
        if (cellHeight > 0) {
            int remainder = y % cellHeight;
            y = remainder < 0 ? (y -= cellHeight + remainder) : (y -= remainder);
        }
        super.setVirtualOrigin(x, y);
    }

    @Override
    protected void scrollY(ScrollBar vBar) {
        int deltaY;
        int vSelection = vBar.getSelection();
        Rectangle bounds = this.getVirtualBounds();
        int y = -vSelection;
        int cellHeight = this.getCellHeight();
        if (cellHeight > 0) {
            int remainder = y % cellHeight;
            y = remainder < 0 ? (y -= cellHeight + remainder) : (y -= remainder);
        }
        if ((deltaY = y - bounds.y) != 0) {
            this.scrollSmart(0, deltaY);
            this.setVirtualOrigin(bounds.x, bounds.y += deltaY);
        }
        if (-bounds.y + this.getRows() * this.getCellHeight() >= bounds.height) {
            Rectangle clientRect = this.getClientArea();
            this.redraw(0, clientRect.height - this.fCellHeight, clientRect.width, this.fCellHeight, false);
        }
    }
}

