/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.ui.refactoring.model;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.mapping.ModelProvider;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptorProxy;
import org.eclipse.ltk.core.refactoring.history.RefactoringHistory;
import org.eclipse.ltk.internal.core.refactoring.history.RefactoringHistoryImplementation;
import org.eclipse.ltk.internal.core.refactoring.history.RefactoringHistoryService;
import org.eclipse.ltk.internal.ui.refactoring.RefactoringUIMessages;
import org.eclipse.ltk.internal.ui.refactoring.RefactoringUIPlugin;
import org.eclipse.ltk.internal.ui.refactoring.model.RefactoringHistoryMergeWizard;
import org.eclipse.ltk.ui.refactoring.history.RefactoringHistoryControlConfiguration;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.diff.IDiff;
import org.eclipse.team.core.diff.IThreeWayDiff;
import org.eclipse.team.core.diff.ITwoWayDiff;
import org.eclipse.team.core.history.IFileRevision;
import org.eclipse.team.core.mapping.IMergeContext;
import org.eclipse.team.core.mapping.IResourceDiff;
import org.eclipse.team.core.mapping.ResourceMappingMerger;
import org.eclipse.team.core.mapping.provider.MergeStatus;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public abstract class AbstractResourceMappingMerger
extends ResourceMappingMerger {
    private final ModelProvider fModelProvider;

    private static Shell getActiveShell() {
        IWorkbenchWindow window;
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench != null && (window = workbench.getActiveWorkbenchWindow()) != null) {
            return window.getShell();
        }
        return null;
    }

    private static IProject[] getAffectedProjects(RefactoringHistory history) {
        HashSet<IProject> set = new HashSet<IProject>();
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        RefactoringDescriptorProxy[] refactoringDescriptorProxyArray = history.getDescriptors();
        int n = refactoringDescriptorProxyArray.length;
        int n2 = 0;
        while (n2 < n) {
            RefactoringDescriptorProxy proxy = refactoringDescriptorProxyArray[n2];
            String name = proxy.getProject();
            if (name == null || "".equals(name)) {
                return null;
            }
            set.add(root.getProject(name));
            ++n2;
        }
        IProject[] projects = new IProject[set.size()];
        set.toArray(projects);
        return projects;
    }

    private static Shell getDialogShell() {
        Shell[] shell = new Shell[1];
        Display.getDefault().syncExec(() -> {
            Shell shell = AbstractResourceMappingMerger.getActiveShell();
        });
        return shell[0];
    }

    protected AbstractResourceMappingMerger(ModelProvider provider) {
        Assert.isNotNull((Object)provider);
        this.fModelProvider = provider;
    }

    protected IStatus aboutToPerformMerge(IMergeContext context, IProgressMonitor monitor) {
        Assert.isNotNull((Object)context);
        Assert.isNotNull((Object)monitor);
        try {
            monitor.beginTask(RefactoringUIMessages.RefactoringModelMerger_merge_message, 100);
            IDiff[] diffs = this.getDiffs(context);
            RefactoringHistory history = this.getRefactoringHistory(diffs, monitor);
            if (history != null && !history.isEmpty()) {
                IProject[] dependencies;
                boolean execute = true;
                IProject[] projects = AbstractResourceMappingMerger.getAffectedProjects(history);
                if (projects != null && (dependencies = this.getDependencies(projects)).length == 0) {
                    execute = false;
                }
                if (execute) {
                    Shell shell = AbstractResourceMappingMerger.getDialogShell();
                    shell.getDisplay().syncExec(() -> {
                        if (MessageDialog.openQuestion((Shell)shell, (String)RefactoringUIMessages.RefactoringWizard_refactoring, (String)RefactoringUIMessages.AbstractRefactoringModelMerger_accept_question)) {
                            RefactoringHistoryModelMergeWizard wizard = new RefactoringHistoryModelMergeWizard();
                            int result = 0;
                            try {
                                wizard.setConfiguration(new RefactoringHistoryModelMergeConfiguration(projects != null && projects.length == 1 ? projects[0] : null));
                                wizard.setInput(history);
                                result = new WizardDialog(shell, (IWizard)wizard).open();
                            }
                            finally {
                                if (result != 1) {
                                    wizard.resolveConflicts(context);
                                }
                            }
                        }
                    });
                }
            }
        }
        finally {
            monitor.done();
        }
        return Status.OK_STATUS;
    }

    private IStatus createMergeStatus(IMergeContext context, IStatus status) {
        if (status.getCode() == 1) {
            return new MergeStatus(status.getPlugin(), status.getMessage(), context.getScope().getMappings(this.fModelProvider.getDescriptor().getId()));
        }
        return status;
    }

    protected abstract IProject[] getDependencies(IProject[] var1);

    private IDiff[] getDiffs(IMergeContext context) {
        HashSet<IDiff> set = new HashSet<IDiff>();
        ResourceMapping[] resourceMappingArray = context.getScope().getMappings(this.fModelProvider.getDescriptor().getId());
        int n = resourceMappingArray.length;
        int n2 = 0;
        while (n2 < n) {
            ResourceMapping mapping = resourceMappingArray[n2];
            IDiff[] diffs = context.getDiffTree().getDiffs(context.getScope().getTraversals(mapping));
            set.addAll(Arrays.asList(diffs));
            ++n2;
        }
        return set.toArray(new IDiff[set.size()]);
    }

    protected final ModelProvider getModelProvider() {
        return this.fModelProvider;
    }

    private RefactoringHistory getRefactoringHistory(IDiff[] diffs, IProgressMonitor monitor) {
        HashSet<RefactoringDescriptor> result = new HashSet<RefactoringDescriptor>();
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)RefactoringUIMessages.RefactoringModelMerger_retrieving_refactorings, (int)(diffs.length * 2));
        try {
            IDiff[] iDiffArray = diffs;
            int n = diffs.length;
            int n2 = 0;
            while (n2 < n) {
                IDiff diff = iDiffArray[n2];
                if (diff instanceof IThreeWayDiff) {
                    String name;
                    IResourceDiff resourceDiff;
                    IFileRevision revision;
                    ITwoWayDiff remoteDiff;
                    String name2;
                    IResourceDiff resourceDiff2;
                    IFileRevision revision2;
                    IThreeWayDiff threeWay = (IThreeWayDiff)diff;
                    HashSet<RefactoringDescriptor> localDescriptors = new HashSet<RefactoringDescriptor>();
                    HashSet<RefactoringDescriptor> remoteDescriptors = new HashSet<RefactoringDescriptor>();
                    ITwoWayDiff localDiff = threeWay.getLocalChange();
                    if (localDiff instanceof IResourceDiff && localDiff.getKind() != 0 && (revision2 = (resourceDiff2 = (IResourceDiff)localDiff).getAfterState()) != null && "refactorings.history".equalsIgnoreCase(name2 = revision2.getName())) {
                        AbstractResourceMappingMerger.getRefactoringDescriptors(revision2, localDescriptors, (IProgressMonitor)subMonitor.newChild(1, 1));
                    }
                    if ((remoteDiff = threeWay.getLocalChange()) instanceof IResourceDiff && remoteDiff.getKind() != 0 && (revision = (resourceDiff = (IResourceDiff)remoteDiff).getAfterState()) != null && "refactorings.history".equalsIgnoreCase(name = revision.getName())) {
                        AbstractResourceMappingMerger.getRefactoringDescriptors(revision, remoteDescriptors, (IProgressMonitor)subMonitor.newChild(1, 1));
                    }
                    remoteDescriptors.removeAll(localDescriptors);
                    result.addAll(remoteDescriptors);
                }
                ++n2;
            }
        }
        finally {
            subMonitor.done();
        }
        return new RefactoringHistoryImplementation(result.toArray(new RefactoringDescriptorProxy[result.size()]));
    }

    static final void getRefactoringDescriptors(IFileRevision revision, Set<RefactoringDescriptor> descriptors, IProgressMonitor monitor) {
        block18: {
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)RefactoringUIMessages.RefactoringModelMerger_retrieving_refactorings, (int)1);
            try {
                IStorage storage = null;
                try {
                    storage = revision.getStorage((IProgressMonitor)subMonitor.newChild(1, 1));
                }
                catch (CoreException exception) {
                    RefactoringUIPlugin.log(exception);
                }
                if (storage == null) break block18;
                InputStream stream = null;
                try {
                    try {
                        stream = storage.getContents();
                        RefactoringHistory history = RefactoringHistoryService.getInstance().readRefactoringHistory(stream, 4);
                        RefactoringDescriptorProxy[] refactoringDescriptorProxyArray = history.getDescriptors();
                        int n = refactoringDescriptorProxyArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            RefactoringDescriptorProxy proxy = refactoringDescriptorProxyArray[n2];
                            descriptors.add(proxy.requestDescriptor(null));
                            ++n2;
                        }
                    }
                    catch (CoreException exception) {
                        RefactoringUIPlugin.log(exception);
                        if (stream == null) break block18;
                        try {
                            stream.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
                finally {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
            finally {
                subMonitor.done();
            }
        }
    }

    public IStatus merge(IMergeContext context, IProgressMonitor monitor) throws CoreException {
        Assert.isNotNull((Object)context);
        IStatus status = Status.OK_STATUS;
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)RefactoringUIMessages.RefactoringModelMerger_merge_message, (int)200);
        try {
            if (status.getSeverity() != 4) {
                IDiff[] diffs = this.getDiffs(context);
                status = this.createMergeStatus(context, context.merge(diffs, false, (IProgressMonitor)subMonitor.newChild(100)));
                int code = status.getCode();
                if (status.getSeverity() != 4 && code != 1 && code != 2) {
                    status = this.mergePerformed(context, (IProgressMonitor)subMonitor.newChild(25));
                }
            }
        }
        finally {
            subMonitor.done();
        }
        return status;
    }

    protected IStatus mergePerformed(IMergeContext context, IProgressMonitor monitor) {
        Assert.isNotNull((Object)context);
        Assert.isNotNull((Object)monitor);
        try {
            monitor.beginTask(RefactoringUIMessages.RefactoringModelMerger_merge_message, 1);
            IStatus iStatus = Status.OK_STATUS;
            return iStatus;
        }
        finally {
            monitor.done();
        }
    }

    private static final class RefactoringHistoryModelMergeConfiguration
    extends RefactoringHistoryControlConfiguration {
        public RefactoringHistoryModelMergeConfiguration(IProject project) {
            super(project, false, false);
        }

        @Override
        public String getProjectPattern() {
            return RefactoringUIMessages.RefactoringModelMerger_project_pattern;
        }

        @Override
        public String getWorkspaceCaption() {
            return RefactoringUIMessages.RefactoringModelMerger_workspace_caption;
        }
    }

    private static final class RefactoringHistoryModelMergeWizard
    extends RefactoringHistoryMergeWizard {
        public RefactoringHistoryModelMergeWizard() {
            super(RefactoringUIMessages.RefactoringWizard_refactoring, RefactoringUIMessages.AbstractRefactoringModelMerger_wizard_title, RefactoringUIMessages.AbstractRefactoringModelMerger_wizard_description);
        }
    }
}

