/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.ui.internal.view;

import java.util.List;
import org.eclipse.buildship.ui.internal.PluginImage;
import org.eclipse.buildship.ui.internal.PluginImages;
import org.eclipse.buildship.ui.internal.view.MultiPageView;
import org.eclipse.buildship.ui.internal.view.Page;
import org.eclipse.buildship.ui.internal.view.SwitchToIndexPageAction;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;

public final class SwitchToNextPageAction
extends Action
implements IMenuCreator {
    private final MultiPageView multiPageView;
    private MenuManager menuManager;

    public SwitchToNextPageAction(MultiPageView multiPageView, String toolTip) {
        super(null, 4);
        this.multiPageView = multiPageView;
        this.setToolTipText(toolTip);
        this.setImageDescriptor(PluginImages.SWITCH_PAGE.withState(PluginImage.ImageState.ENABLED).getImageDescriptor());
        this.setMenuCreator(this);
    }

    public void run() {
        this.multiPageView.switchToNextPage();
    }

    public Menu getMenu(Control parent) {
        if (this.menuManager != null) {
            this.menuManager.dispose();
        }
        this.menuManager = new MenuManager();
        this.menuManager.createContextMenu(parent);
        Page currentPage = this.multiPageView.getCurrentPage();
        List<Page> pages = this.multiPageView.getPages();
        for (int i = 0; i < pages.size(); ++i) {
            Page page = pages.get(i);
            SwitchToIndexPageAction switchToIndexPageAction = new SwitchToIndexPageAction(page.getDisplayName(), i, this.multiPageView);
            switchToIndexPageAction.setChecked(page.equals(currentPage));
            this.menuManager.add((IAction)switchToIndexPageAction);
        }
        return this.menuManager.getMenu();
    }

    public Menu getMenu(Menu parent) {
        return null;
    }

    public void dispose() {
        if (this.menuManager != null) {
            this.menuManager.dispose();
        }
    }
}

