/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.commands;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.AbstractOperation;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.mylyn.commons.workbench.WorkbenchUtil;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.actions.ClearOutgoingAction;
import org.eclipse.mylyn.internal.tasks.ui.commands.AbstractTaskHandler;
import org.eclipse.mylyn.internal.tasks.ui.commands.AbstractTaskListViewHandler;
import org.eclipse.mylyn.internal.tasks.ui.commands.GoToUnreadTaskHandler;
import org.eclipse.mylyn.internal.tasks.ui.commands.Messages;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiInternal;
import org.eclipse.mylyn.internal.tasks.ui.util.TreeWalker;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskListView;
import org.eclipse.mylyn.monitor.ui.MonitorUi;
import org.eclipse.mylyn.tasks.core.IRepositoryElement;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

public abstract class MarkTaskHandler
extends AbstractTaskHandler {
    private static void markTasksRead(ExecutionEvent event, ITask[] tasks, boolean markRead) throws ExecutionException {
        Shell shell = HandlerUtil.getActiveShell((ExecutionEvent)event);
        String label = markRead ? Messages.MarkTaskHandler_MarkTasksReadOperation : Messages.MarkTaskHandler_MarkTasksUnreadOperation;
        MarkTaskReadOperation operation = new MarkTaskReadOperation(shell, label, markRead, tasks);
        operation.execute();
    }

    public static class ClearActiveTimeHandler
    extends AbstractTaskHandler {
        public ClearActiveTimeHandler() {
            this.setFilterBasedOnActiveTaskList(true);
        }

        @Override
        protected void execute(ExecutionEvent event, ITask task) throws ExecutionException {
            if (MessageDialog.openConfirm((Shell)WorkbenchUtil.getShell(), (String)org.eclipse.mylyn.internal.tasks.ui.editors.Messages.TaskEditorPlanningPart_Confirm_Activity_Time_Deletion, (String)org.eclipse.mylyn.internal.tasks.ui.editors.Messages.TaskEditorPlanningPart_Do_you_wish_to_reset_your_activity_time_on_this_task_)) {
                MonitorUi.getActivityContextManager().removeActivityTime(task.getHandleIdentifier(), 0L, System.currentTimeMillis());
            }
        }
    }

    public static class ClearOutgoingHandler
    extends AbstractTaskHandler {
        public ClearOutgoingHandler() {
            this.setFilterBasedOnActiveTaskList(true);
        }

        @Override
        protected void execute(ExecutionEvent event, ITask task) throws ExecutionException {
            ClearOutgoingAction action = new ClearOutgoingAction(Collections.singletonList(task));
            if (action.isEnabled()) {
                action.run();
            }
        }
    }

    public static class MarkTaskCompleteHandler
    extends AbstractTaskHandler {
        public static final String ID_COMMAND = "org.eclipse.mylyn.tasks.ui.command.markTaskComplete";

        public MarkTaskCompleteHandler() {
            this.setFilterBasedOnActiveTaskList(true);
        }

        @Override
        protected void execute(ExecutionEvent event, ITask task) throws ExecutionException {
            if (TasksUiInternal.hasLocalCompletionState(task)) {
                task.setCompletionDate(new Date());
                TasksUiPlugin.getTaskList().notifyElementChanged((IRepositoryElement)task);
            }
        }
    }

    public static class MarkTaskIncompleteHandler
    extends AbstractTaskHandler {
        public MarkTaskIncompleteHandler() {
            this.setFilterBasedOnActiveTaskList(true);
        }

        @Override
        protected void execute(ExecutionEvent event, ITask task) throws ExecutionException {
            if (TasksUiInternal.hasLocalCompletionState(task)) {
                task.setCompletionDate(null);
                TasksUiPlugin.getTaskList().notifyElementChanged((IRepositoryElement)task);
            }
        }
    }

    public static class MarkTaskReadGoToNextUnreadTaskHandler
    extends AbstractTaskListViewHandler {
        @Override
        protected void execute(ExecutionEvent event, TaskListView taskListView, IRepositoryElement item) throws ExecutionException {
            if (item instanceof ITask) {
                ITask task = (ITask)item;
                MarkTaskHandler.markTasksRead(event, new ITask[]{task}, true);
                GoToUnreadTaskHandler.execute(event, TreeWalker.Direction.DOWN);
            }
        }
    }

    public static class MarkTaskReadGoToPreviousUnreadTaskHandler
    extends AbstractTaskListViewHandler {
        @Override
        protected void execute(ExecutionEvent event, TaskListView taskListView, IRepositoryElement item) throws ExecutionException {
            if (item instanceof ITask) {
                ITask task = (ITask)item;
                MarkTaskHandler.markTasksRead(event, new ITask[]{task}, true);
                GoToUnreadTaskHandler.execute(event, TreeWalker.Direction.UP);
            }
        }
    }

    public static class MarkTaskReadHandler
    extends AbstractTaskHandler {
        public static final String ID_COMMAND = "org.eclipse.mylyn.tasks.ui.command.markTaskRead";

        public MarkTaskReadHandler() {
            this.setFilterBasedOnActiveTaskList(true);
        }

        @Override
        protected void execute(ExecutionEvent event, ITask[] tasks) throws ExecutionException {
            MarkTaskHandler.markTasksRead(event, tasks, true);
        }
    }

    private static class MarkTaskReadOperation
    extends AbstractOperation {
        private final IAdaptable info = new IAdaptable(){

            public <T> T getAdapter(Class<T> adapter) {
                if (adapter == Shell.class) {
                    return adapter.cast(shell);
                }
                return null;
            }
        };
        private final boolean markRead;
        private List<ITask> tasks;
        private final Shell shell;

        public MarkTaskReadOperation(Shell shell, String label, boolean markRead, ITask[] tasks) {
            super(label);
            this.shell = shell;
            this.markRead = markRead;
            this.tasks = Arrays.asList(tasks);
            this.addContext(TasksUiInternal.getUndoContext());
        }

        private void execute() throws ExecutionException {
            IOperationHistory operationHistory = PlatformUI.getWorkbench().getOperationSupport().getOperationHistory();
            operationHistory.execute((IUndoableOperation)this, (IProgressMonitor)new NullProgressMonitor(), this.info);
        }

        public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            ArrayList<ITask> affectedTasks = new ArrayList<ITask>(this.tasks.size());
            for (ITask task : this.tasks) {
                if (!TasksUiPlugin.getTaskDataManager().setTaskRead(task, this.markRead)) continue;
                affectedTasks.add(task);
            }
            if (!affectedTasks.containsAll(this.tasks)) {
                this.tasks = affectedTasks;
            }
            return Status.OK_STATUS;
        }

        public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            for (ITask task : this.tasks) {
                TasksUiPlugin.getTaskDataManager().setTaskRead(task, !this.markRead);
            }
            return Status.OK_STATUS;
        }

        public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            return this.execute(monitor, info);
        }
    }

    public static class MarkTaskUnreadHandler
    extends AbstractTaskHandler {
        public MarkTaskUnreadHandler() {
            this.setFilterBasedOnActiveTaskList(true);
        }

        @Override
        protected void execute(ExecutionEvent event, ITask[] tasks) throws ExecutionException {
            MarkTaskHandler.markTasksRead(event, tasks, false);
        }
    }
}

