/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.core.refactoring;

import java.util.HashMap;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.debug.core.IJavaBreakpoint;
import org.eclipse.jdt.debug.core.IJavaWatchpoint;
import org.eclipse.jdt.debug.core.JDIDebugModel;
import org.eclipse.jdt.internal.debug.core.refactoring.DeleteBreakpointChange;
import org.eclipse.jdt.internal.debug.core.refactoring.RefactoringMessages;
import org.eclipse.jdt.internal.debug.core.refactoring.WatchpointChange;
import org.eclipse.jdt.internal.debug.ui.BreakpointUtils;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.osgi.util.NLS;

public class WatchpointTypeChange
extends WatchpointChange {
    private final IType fDestType;
    private final IType fOriginalType;

    public WatchpointTypeChange(IJavaWatchpoint watchpoint, IType destType, IType originalType) throws CoreException {
        super(watchpoint);
        this.fDestType = destType;
        this.fOriginalType = originalType;
    }

    public String getName() {
        String msg = NLS.bind((String)RefactoringMessages.WatchpointTypeChange_1, (Object)this.getBreakpointLabel((IBreakpoint)this.getOriginalBreakpoint()));
        if (!"".equals(this.fDestType.getElementName())) {
            msg = NLS.bind((String)RefactoringMessages.WatchpointTypeChange_0, (Object)this.getBreakpointLabel((IBreakpoint)this.getOriginalBreakpoint()), (Object)this.fDestType.getElementName());
        }
        return msg;
    }

    public Change perform(IProgressMonitor pm) throws CoreException {
        IField destField = this.fDestType.getField(this.getFieldName());
        HashMap<String, Object> map = new HashMap<String, Object>();
        BreakpointUtils.addJavaBreakpointAttributes(map, (IJavaElement)destField);
        IResource resource = BreakpointUtils.getBreakpointResource((IMember)destField);
        int[] range = this.getNewLineNumberAndRange((IMember)destField);
        IJavaWatchpoint breakpoint = JDIDebugModel.createWatchpoint((IResource)resource, (String)this.fDestType.getFullyQualifiedName(), (String)this.getFieldName(), (int)-1, (int)range[1], (int)range[2], (int)this.getHitCount(), (boolean)true, map);
        this.apply(breakpoint);
        this.getOriginalBreakpoint().delete();
        return new DeleteBreakpointChange((IJavaBreakpoint)breakpoint);
    }

    public IType getDestinationType() {
        return this.fDestType;
    }

    public IType getOriginalType() {
        return this.fOriginalType;
    }
}

