/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.spy.event.internal.core;

import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.internal.workbench.UIEventPublisher;
import org.eclipse.e4.ui.services.internal.events.EventBroker;
import org.eclipse.e4.ui.workbench.UIEvents;
import org.eclipse.pde.spy.event.internal.core.CapturedEventFilterMatcher;
import org.eclipse.pde.spy.event.internal.model.CapturedEvent;
import org.eclipse.pde.spy.event.internal.model.CapturedEventFilter;
import org.osgi.service.event.EventHandler;

public class EventMonitor {
    private static Set<Integer> EVENT_HELPER_CLASSES = Set.of(Integer.valueOf(UIEvents.class.getName().hashCode()), Integer.valueOf(UIEventPublisher.class.getName().hashCode()));
    private Collection<CapturedEventFilter> filters;
    private final IEventBroker eventBroker;
    private NewEventListener listener;
    private CapturedEventFilterMatcher eventFilterMatcher;
    private final EventHandler eventHandler = event -> {
        if (this.listener == null) {
            return;
        }
        CapturedEvent capturedEvent = new CapturedEvent();
        capturedEvent.setTopic(event.getTopic());
        capturedEvent.setPublisherClassName(this.getPublisherClassName());
        String[] stringArray = event.getPropertyNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String propertyName = stringArray[n2];
            Object value = event.getProperty(propertyName);
            capturedEvent.addParameter(propertyName, value);
            if (value != null && "ChangedElement".equals(propertyName)) {
                capturedEvent.setChangedElementClassName(value.getClass().getName());
            }
            ++n2;
        }
        if (this.shouldBeCaptured(capturedEvent)) {
            this.listener.newEvent(capturedEvent);
        }
    };

    public EventMonitor(IEventBroker eventBroker) {
        this.eventBroker = eventBroker;
    }

    public void start(String baseTopic, Collection<CapturedEventFilter> filters) {
        this.filters = filters;
        this.eventBroker.subscribe(baseTopic, this.eventHandler);
    }

    public void stop() {
        this.eventBroker.unsubscribe(this.eventHandler);
    }

    public void setNewEventListener(NewEventListener listener) {
        this.listener = listener;
    }

    private boolean shouldBeCaptured(CapturedEvent event) {
        if (this.filters != null) {
            Iterator<CapturedEventFilter> iter = this.filters.iterator();
            while (iter.hasNext()) {
                if (this.getEventFilterMatcher().matches(event, iter.next())) continue;
                return false;
            }
        }
        return true;
    }

    private String getPublisherClassName() {
        StackTraceElement[] items = Thread.currentThread().getStackTrace();
        boolean foundEventBroker = false;
        int i = 0;
        while (i < items.length) {
            String clsName = items[i].getClassName();
            if (!foundEventBroker && clsName.equals(EventBroker.class.getName())) {
                foundEventBroker = true;
            } else if (foundEventBroker && !EVENT_HELPER_CLASSES.contains(clsName.hashCode())) {
                return String.format("%s (%s:%d)", clsName, items[i].getMethodName(), items[i].getLineNumber());
            }
            ++i;
        }
        return "";
    }

    private CapturedEventFilterMatcher getEventFilterMatcher() {
        if (this.eventFilterMatcher == null) {
            this.eventFilterMatcher = new CapturedEventFilterMatcher();
        }
        return this.eventFilterMatcher;
    }

    public static interface NewEventListener {
        public void newEvent(CapturedEvent var1);
    }
}

