/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.core.internal.analysis.filter;

import org.jacoco.core.internal.analysis.filter.AbstractMatcher;
import org.jacoco.core.internal.analysis.filter.IFilter;
import org.jacoco.core.internal.analysis.filter.IFilterContext;
import org.jacoco.core.internal.analysis.filter.IFilterOutput;
import org.jacoco.core.internal.analysis.filter.Replacements;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LookupSwitchInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TableSwitchInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

final class KotlinWhenStringFilter
implements IFilter {
    KotlinWhenStringFilter() {
    }

    public void filter(MethodNode methodNode, IFilterContext context, IFilterOutput output) {
        Matcher matcher = new Matcher();
        for (AbstractInsnNode i : methodNode.instructions) {
            matcher.match(i, output);
        }
    }

    private static class Matcher
    extends AbstractMatcher {
        private Matcher() {
        }

        public void match(AbstractInsnNode start, IFilterOutput output) {
            int hashCodes;
            LabelNode defaultLabel;
            if (25 != start.getOpcode()) {
                return;
            }
            this.cursor = start;
            this.nextIsInvoke(182, "java/lang/String", "hashCode", "()I");
            this.nextIsSwitch();
            if (this.cursor == null) {
                return;
            }
            this.vars.put("s", (VarInsnNode)start);
            AbstractInsnNode s = this.cursor;
            if (s.getOpcode() == 171) {
                LookupSwitchInsnNode lookupSwitch = (LookupSwitchInsnNode)this.cursor;
                defaultLabel = lookupSwitch.dflt;
                hashCodes = lookupSwitch.labels.size();
            } else {
                TableSwitchInsnNode tableSwitch = (TableSwitchInsnNode)this.cursor;
                defaultLabel = tableSwitch.dflt;
                hashCodes = tableSwitch.labels.size();
            }
            if (hashCodes == 0) {
                return;
            }
            Replacements replacements = new Replacements();
            replacements.add((AbstractInsnNode)defaultLabel, s, 0);
            for (int i = 1; i <= hashCodes; ++i) {
                JumpInsnNode jump;
                block9: {
                    do {
                        this.nextIsVar(25, "s");
                        this.nextIs(18);
                        this.nextIsInvoke(182, "java/lang/String", "equals", "(Ljava/lang/Object;)Z");
                        this.nextIs(153);
                        jump = (JumpInsnNode)this.cursor;
                        this.next();
                        if (this.cursor == null) {
                            return;
                        }
                        if (this.cursor.getOpcode() != 167) break block9;
                        replacements.add((AbstractInsnNode)((JumpInsnNode)this.cursor).label, this.cursor, 1);
                    } while (jump.label != defaultLabel);
                    replacements.add((AbstractInsnNode)defaultLabel, (AbstractInsnNode)jump, 1);
                    continue;
                }
                if (i == hashCodes && jump.label == defaultLabel) {
                    replacements.add((AbstractInsnNode)defaultLabel, (AbstractInsnNode)jump, 1);
                    replacements.add(this.cursor, (AbstractInsnNode)jump, 0);
                    this.cursor = jump;
                    continue;
                }
                return;
            }
            output.ignore(s.getNext(), this.cursor);
            output.replaceBranches(s, replacements);
        }
    }
}

