/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.corext.refactoring.code.flow;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTCompoundStatement;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclarationStatement;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTForStatement;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTParameterDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTReturnStatement;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTStandardFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IField;
import org.eclipse.cdt.core.dom.ast.IVariable;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTCatchHandler;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTRangeBasedForStatement;
import org.eclipse.cdt.core.dom.ast.gnu.c.ICASTKnRFunctionDeclarator;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPVisitor;
import org.eclipse.cdt.internal.corext.refactoring.code.flow.FlowAnalyzer;
import org.eclipse.cdt.internal.corext.refactoring.code.flow.FlowContext;
import org.eclipse.cdt.internal.corext.refactoring.code.flow.FlowInfo;
import org.eclipse.cdt.internal.corext.refactoring.code.flow.GenericSequentialFlowInfo;

public class InOutFlowAnalyzer
extends FlowAnalyzer {
    public InOutFlowAnalyzer(FlowContext context) {
        super(context);
    }

    public FlowInfo perform(IASTNode[] selectedNodes) {
        FlowContext context = this.getFlowContext();
        GenericSequentialFlowInfo result = this.createSequential();
        int i = 0;
        while (i < selectedNodes.length) {
            IASTNode node = selectedNodes[i];
            node.accept((ASTVisitor)this);
            result.merge(this.getFlowInfo(node), context);
            ++i;
        }
        return result;
    }

    @Override
    protected boolean traverseNode(IASTNode node) {
        return true;
    }

    @Override
    protected boolean shouldCreateReturnFlowInfo(IASTReturnStatement node) {
        return true;
    }

    @Override
    public int leave(IASTCompoundStatement node) {
        super.leave(node);
        this.clearAccessMode(this.accessFlowInfo((IASTNode)node), node.getStatements());
        return 1;
    }

    @Override
    public int leave(ICPPASTCatchHandler node) {
        super.leave(node);
        this.clearAccessMode(this.accessFlowInfo((IASTNode)node), node.getDeclaration());
        return 1;
    }

    @Override
    public int leave(IASTForStatement node) {
        super.leave(node);
        this.clearAccessMode(this.accessFlowInfo((IASTNode)node), node.getInitializerStatement());
        return 1;
    }

    @Override
    public int leave(ICPPASTRangeBasedForStatement node) {
        super.leave(node);
        this.clearAccessMode(this.accessFlowInfo((IASTNode)node), node.getDeclaration());
        return 1;
    }

    @Override
    public int leave(IASTFunctionDefinition node) {
        block3: {
            IASTFunctionDeclarator declarator;
            FlowInfo info;
            block2: {
                super.leave(node);
                info = this.accessFlowInfo((IASTNode)node);
                declarator = node.getDeclarator();
                if (!(declarator instanceof IASTStandardFunctionDeclarator)) break block2;
                IASTParameterDeclaration[] iASTParameterDeclarationArray = ((IASTStandardFunctionDeclarator)declarator).getParameters();
                int n = iASTParameterDeclarationArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IASTParameterDeclaration param = iASTParameterDeclarationArray[n2];
                    this.clearAccessMode(info, param.getDeclarator());
                    ++n2;
                }
                break block3;
            }
            if (!(declarator instanceof ICASTKnRFunctionDeclarator)) break block3;
            IASTDeclaration[] iASTDeclarationArray = ((ICASTKnRFunctionDeclarator)declarator).getParameterDeclarations();
            int n = iASTDeclarationArray.length;
            int n3 = 0;
            while (n3 < n) {
                IASTDeclaration param = iASTDeclarationArray[n3];
                this.clearAccessMode(info, param);
                ++n3;
            }
        }
        return 1;
    }

    private void clearAccessMode(FlowInfo info, IASTStatement[] statements) {
        if (statements == null || statements.length == 0 || info == null) {
            return;
        }
        IASTStatement[] iASTStatementArray = statements;
        int n = statements.length;
        int n2 = 0;
        while (n2 < n) {
            IASTStatement statement = iASTStatementArray[n2];
            this.clearAccessMode(info, statement);
            ++n2;
        }
    }

    private void clearAccessMode(FlowInfo info, IASTStatement statement) {
        if (statement instanceof IASTDeclarationStatement) {
            IASTDeclaration declaration = ((IASTDeclarationStatement)statement).getDeclaration();
            this.clearAccessMode(info, declaration);
        }
    }

    private void clearAccessMode(FlowInfo info, IASTDeclaration declaration) {
        if (declaration instanceof IASTSimpleDeclaration) {
            IASTDeclarator[] declarators;
            IASTDeclarator[] iASTDeclaratorArray = declarators = ((IASTSimpleDeclaration)declaration).getDeclarators();
            int n = declarators.length;
            int n2 = 0;
            while (n2 < n) {
                IASTDeclarator declarator = iASTDeclaratorArray[n2];
                this.clearAccessMode(info, declarator);
                ++n2;
            }
        }
    }

    private void clearAccessMode(FlowInfo info, IASTDeclarator declarator) {
        IASTName name = (declarator = CPPVisitor.findInnermostDeclarator((IASTDeclarator)declarator)).getName();
        IBinding binding = name.resolveBinding();
        if (binding instanceof IVariable && !(binding instanceof IField)) {
            info.clearAccessMode((IVariable)binding, this.fFlowContext);
        }
    }
}

