/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.mi.service.command.output;

import org.eclipse.cdt.dsf.mi.service.command.output.MIConst;
import org.eclipse.cdt.dsf.mi.service.command.output.MIFrame;
import org.eclipse.cdt.dsf.mi.service.command.output.MIInfo;
import org.eclipse.cdt.dsf.mi.service.command.output.MIOutput;
import org.eclipse.cdt.dsf.mi.service.command.output.MIResult;
import org.eclipse.cdt.dsf.mi.service.command.output.MIResultRecord;
import org.eclipse.cdt.dsf.mi.service.command.output.MITuple;
import org.eclipse.cdt.dsf.mi.service.command.output.MIValue;

public class MITraceRecord
extends MIInfo {
    private MIFrame fStackFrame = null;
    private Integer fTracepoint = null;
    private Integer fRecordIndex = null;

    public MITraceRecord(MIOutput out) {
        super(out);
        this.parse();
    }

    public MIFrame getStackFrame() {
        return this.fStackFrame;
    }

    public Integer getTracepointId() {
        return this.fTracepoint;
    }

    public Integer getRecordIndex() {
        return this.fRecordIndex;
    }

    private void parse() {
        MIOutput out;
        MIResultRecord rr;
        if (this.isDone() && (rr = (out = this.getMIOutput()).getMIResultRecord()) != null) {
            MIResult[] results = rr.getMIResults();
            int i = 0;
            while (i < results.length) {
                MIValue value;
                String var = results[i].getVariable();
                if (var.equals("traceframe")) {
                    val = results[i].getMIValue();
                    if (val instanceof MIConst) {
                        try {
                            this.fRecordIndex = Integer.parseInt(((MIConst)val).getString());
                        }
                        catch (NumberFormatException numberFormatException) {}
                    }
                } else if (var.equals("tracepoint")) {
                    val = results[i].getMIValue();
                    if (val instanceof MIConst) {
                        try {
                            this.fTracepoint = Integer.parseInt(((MIConst)val).getString());
                        }
                        catch (NumberFormatException numberFormatException) {}
                    }
                } else if (var.equals("frame") && (value = results[i].getMIValue()) instanceof MITuple) {
                    this.fStackFrame = new MIFrame((MITuple)value);
                }
                ++i;
            }
        }
    }
}

