/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.debug.internal.ui;

import com.ibm.icu.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.core.IAddress;
import org.eclipse.cdt.debug.internal.core.sourcelookup.ICSourceNotFoundDescription;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.Query;
import org.eclipse.cdt.dsf.debug.service.IStack;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.launch.MessagesForLaunchVM;
import org.eclipse.cdt.dsf.internal.ui.DsfUIPlugin;
import org.eclipse.cdt.dsf.service.DsfServicesTracker;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.preference.IPreferenceStore;

public class CSourceNotFoundDescriptionFactory
implements IAdapterFactory {
    public <T> T getAdapter(Object adaptableObject, Class<T> adapterType) {
        if (adapterType.equals(ICSourceNotFoundDescription.class) && adaptableObject instanceof IStack.IFrameDMContext) {
            final IStack.IFrameDMContext frameDMC = (IStack.IFrameDMContext)adaptableObject;
            Query<IStack.IFrameDMData> query = new Query<IStack.IFrameDMData>(){

                protected void execute(DataRequestMonitor<IStack.IFrameDMData> rm) {
                    DsfServicesTracker tracker = new DsfServicesTracker(DsfUIPlugin.getBundleContext(), frameDMC.getSessionId());
                    IStack stack = (IStack)tracker.getService(IStack.class);
                    if (stack != null) {
                        stack.getFrameData(frameDMC, rm);
                    } else {
                        rm.setData(null);
                        rm.done();
                    }
                    tracker.dispose();
                }
            };
            DsfSession session = DsfSession.getSession((String)frameDMC.getSessionId());
            if (session != null && session.getExecutor() != null) {
                session.getExecutor().execute((Runnable)query);
                try {
                    IStack.IFrameDMData dmData = (IStack.IFrameDMData)query.get();
                    return (T)CSourceNotFoundDescriptionFactory.getFrameDescription(dmData);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    public Class<?>[] getAdapterList() {
        return new Class[]{ICSourceNotFoundDescription.class};
    }

    private static ICSourceNotFoundDescription getFrameDescription(IStack.IFrameDMData frame) {
        String formatString = "";
        String[] propertyNames = null;
        HashMap<String, Object> properties = new HashMap<String, Object>();
        CSourceNotFoundDescriptionFactory.fillFrameDataProperties(properties, frame);
        Integer line = (Integer)properties.get("frame_line");
        String file = (String)properties.get("frame_file");
        String function = (String)properties.get("frame_function");
        String module = (String)properties.get("frame_module");
        boolean isAddress = false;
        if (line != null && line >= 0 && file != null && !file.isEmpty()) {
            formatString = function != null && function.contains(")") ? MessagesForLaunchVM.StackFramesVMNode_No_columns__text_format : MessagesForLaunchVM.StackFramesVMNode_No_columns__add_parens__text_format;
            propertyNames = new String[]{"frame_address", "frame_function", "frame_file", "frame_line", "frame_column", "frame_module"};
        } else if (function != null && !function.isEmpty() && module != null && !module.isEmpty()) {
            formatString = function.contains(")") ? MessagesForLaunchVM.StackFramesVMNode_No_columns__No_line__text_format : MessagesForLaunchVM.StackFramesVMNode_No_columns__add_parens__text_format;
            propertyNames = new String[]{"frame_address", "frame_function", "frame_module"};
        } else if (module != null && !module.isEmpty()) {
            formatString = MessagesForLaunchVM.StackFramesVMNode_No_columns__No_function__text_format;
            propertyNames = new String[]{"frame_address", "frame_module"};
        } else if (function != null && !function.isEmpty()) {
            formatString = function.contains(")") ? MessagesForLaunchVM.StackFramesVMNode_No_columns__No_module__text_format : MessagesForLaunchVM.StackFramesVMNode_No_columns__No_module__add_parens__text_format;
            propertyNames = new String[]{"frame_address", "frame_function"};
        } else {
            formatString = MessagesForLaunchVM.StackFramesVMNode_No_columns__Address_only__text_format;
            propertyNames = new String[]{"frame_address"};
            isAddress = true;
        }
        Object[] propertyValues = new Object[propertyNames.length];
        int i = 0;
        while (i < propertyNames.length) {
            propertyValues[i] = properties.get(propertyNames[i]);
            ++i;
        }
        final String description = new MessageFormat(formatString).format(propertyValues, new StringBuffer(), null).toString();
        final boolean isAddressReturn = isAddress;
        return new ICSourceNotFoundDescription(){

            public String getDescription() {
                return description;
            }

            public boolean isAddressOnly() {
                return isAddressReturn;
            }
        };
    }

    private static void fillFrameDataProperties(Map<String, Object> properties, IStack.IFrameDMData data) {
        IAddress address = data.getAddress();
        if (address != null) {
            properties.put("frame_address", "0x" + address.toString(16));
        }
        String file = data.getFile();
        IPreferenceStore cStore = CDebugUIPlugin.getDefault().getPreferenceStore();
        boolean show_full_path = cStore.getBoolean("org.eclipse.debug.ui.DebugView.org.eclipse.cdt.debug.ui.cDebug.show_full_paths");
        if (!show_full_path) {
            file = new Path(file).lastSegment();
        }
        properties.put("frame_file", file);
        properties.put("frame_function", data.getFunction());
        properties.put("frame_line", data.getLine());
        properties.put("frame_column", data.getColumn());
        properties.put("frame_module", data.getModule());
    }
}

