/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.cdt.libhover.utils;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.runtime.IPath;
import org.eclipse.linuxtools.internal.cdt.libhover.utils.CDoxygenLibhoverGen;
import org.eclipse.linuxtools.internal.cdt.libhover.utils.CXmlLibhoverGen;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class BuildFunctionInfos {
    private static final String IS_DOXYGEN = "--doxygen";

    public static void main(String[] args) {
        try {
            URI acDoc = new URI(args[0]);
            IPath p = URIUtil.toPath((URI)acDoc);
            InputStream docStream = null;
            if (p == null) {
                URL url = acDoc.toURL();
                docStream = url.openStream();
            } else {
                docStream = new FileInputStream(p.toFile());
            }
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(false);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(docStream);
            CXmlLibhoverGen libhoverInfoGenerator = args.length == 3 && IS_DOXYGEN.equals(args[2]) ? new CDoxygenLibhoverGen(doc) : new CXmlLibhoverGen(doc);
            libhoverInfoGenerator.generate(args[1]);
            System.out.println("Built " + args[1] + " from " + args[0]);
        }
        catch (IOException | URISyntaxException | ParserConfigurationException | SAXException e) {
            e.printStackTrace();
        }
    }
}

