/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.internal;

import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.egit.core.project.RepositoryMapping;
import org.eclipse.jgit.lib.Repository;

public class FileChecker {
    public static CheckResult checkFiles(Repository repository, Collection<String> files) {
        CheckResult result = new CheckResult();
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        String workTreePath = repository.getWorkTree().getAbsolutePath();
        for (String filePath : files) {
            IFile[] filesForLocation = root.findFilesForLocationURI(new File(workTreePath, filePath).toURI());
            if (filesForLocation.length == 0) {
                result.addEntry(filePath, new CheckResultEntry(false, false));
                continue;
            }
            boolean mappedResourceFound = false;
            IFile[] iFileArray = filesForLocation;
            int n = filesForLocation.length;
            int n2 = 0;
            while (n2 < n) {
                IFile file = iFileArray[n2];
                if (RepositoryMapping.getMapping((IResource)file) != null) {
                    mappedResourceFound = true;
                    break;
                }
                ++n2;
            }
            if (mappedResourceFound) continue;
            result.addEntry(filePath, new CheckResultEntry(true, false));
        }
        return result;
    }

    public static class CheckResult {
        private boolean isOk = true;
        private boolean containsNonWorkspaceFiles = false;
        private boolean containsNotSharedResources = false;
        private Map<String, CheckResultEntry> problems = new HashMap<String, CheckResultEntry>();

        public boolean isOk() {
            return this.isOk;
        }

        public boolean containsNonWorkspaceFiles() {
            return this.containsNonWorkspaceFiles;
        }

        public boolean containsNotSharedResources() {
            return this.containsNotSharedResources;
        }

        public Map<String, CheckResultEntry> getProblems() {
            return this.problems;
        }

        void addEntry(String path, CheckResultEntry entry) {
            this.isOk = false;
            if (!entry.inWorkspace) {
                this.containsNonWorkspaceFiles = true;
            }
            if (entry.inWorkspace && !entry.shared) {
                this.containsNotSharedResources = true;
            }
            this.problems.put(path, entry);
        }

        public CheckResultEntry getEntry(String path) {
            return this.problems.get(path);
        }
    }

    public static class CheckResultEntry {
        public final boolean inWorkspace;
        public final boolean shared;

        public CheckResultEntry(boolean inWorkspace, boolean shared) {
            this.inWorkspace = inWorkspace;
            this.shared = shared;
        }
    }
}

