/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.workingsets;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.internal.ui.workingsets.IWorkingSetConfiguration;
import org.eclipse.cdt.internal.ui.workingsets.IWorkingSetProjectConfiguration;
import org.eclipse.cdt.internal.ui.workingsets.IWorkingSetProjectConfigurationFactory;
import org.eclipse.cdt.internal.ui.workingsets.IWorkingSetProxy;
import org.eclipse.cdt.internal.ui.workingsets.WorkingSetConfigurationManager;
import org.eclipse.cdt.internal.ui.workingsets.WorkingSetMessages;
import org.eclipse.cdt.internal.ui.workingsets.WorkspaceSnapshot;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IWorkingSet;

public class WorkingSetConfiguration
implements IWorkingSetConfiguration {
    private final IWorkingSetProxy workingSet;
    private String name;
    private Map<String, IWorkingSetProjectConfiguration> projects;

    protected WorkingSetConfiguration(IWorkingSetProxy workingSet) {
        this.workingSet = workingSet;
    }

    @Override
    public IWorkingSetProxy getWorkingSet() {
        return this.workingSet;
    }

    @Override
    public String getName() {
        return this.name;
    }

    void setName(String name) {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("name is empty");
        }
        if (!name.equals(this.getName())) {
            if (this.getWorkingSet().getConfiguration(name) != null) {
                throw new IllegalArgumentException("name is already in use");
            }
            this.basicSetName(name);
        }
    }

    protected void basicSetName(String name) {
        this.name = name;
    }

    private Map<String, IWorkingSetProjectConfiguration> getProjects() {
        if (this.projects == null) {
            this.projects = new HashMap<String, IWorkingSetProjectConfiguration>();
            for (IProject next : this.workingSet.resolveProjects()) {
                IWorkingSetProjectConfiguration child = this.createProjectConfiguration(next);
                if (child == null) continue;
                this.basicAddProjectConfiguration(child);
            }
        }
        return this.projects;
    }

    protected void basicAddProjectConfiguration(IWorkingSetProjectConfiguration projectConfig) {
        if (this.projects == null) {
            this.projects = new HashMap<String, IWorkingSetProjectConfiguration>();
        }
        this.projects.put(projectConfig.getProjectName(), projectConfig);
    }

    @Override
    public IWorkingSetProjectConfiguration getProjectConfiguration(String projectName) {
        return this.getProjects().get(projectName);
    }

    @Override
    public Collection<IWorkingSetProjectConfiguration> getProjectConfigurations() {
        return this.getProjects().values();
    }

    @Override
    public boolean isActive() {
        boolean result;
        boolean bl = result = !this.getProjects().isEmpty();
        if (result) {
            for (IWorkingSetProjectConfiguration next : this.getProjectConfigurations()) {
                if (next.isActive()) continue;
                result = false;
                break;
            }
        }
        return result;
    }

    @Override
    public void activate() {
        IWorkingSet ws;
        if (!this.isActive()) {
            for (IWorkingSetProjectConfiguration next : this.getProjectConfigurations()) {
                next.activate();
            }
        }
        if ((ws = this.getWorkingSet().resolve()) != null) {
            WorkingSetConfigurationManager.WS_MGR.addRecentWorkingSet(ws);
        }
    }

    @Override
    public IStatus build(IProgressMonitor monitor) {
        MultiStatus result = new MultiStatus("org.eclipse.cdt.ui", 0, WorkingSetMessages.WSConfig_build_problems, null);
        ArrayList<IWorkingSetProjectConfiguration> toBuild = new ArrayList<IWorkingSetProjectConfiguration>(this.getProjectConfigurations().size());
        for (IWorkingSetProjectConfiguration next : this.getProjectConfigurations()) {
            IProject project = next.resolveProject();
            if (project == null || !project.isAccessible()) continue;
            toBuild.add(next);
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)NLS.bind((String)WorkingSetMessages.WSConfig_build_task, (Object)this.getWorkingSet().getName()), (int)toBuild.size());
        try {
            for (IWorkingSetProjectConfiguration next : toBuild) {
                if (progress.isCanceled()) {
                    result.add(Status.CANCEL_STATUS);
                    break;
                }
                IStatus status = next.build((IProgressMonitor)progress.newChild(1));
                if (status == null || status.isOK()) continue;
                result.add(status);
            }
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
        return result.isOK() ? Status.OK_STATUS : result;
    }

    public void saveState(IMemento memento) {
        memento.putString("name", this.getName());
        for (IWorkingSetProjectConfiguration next : this.getProjectConfigurations()) {
            next.saveState(memento.createChild("project"));
        }
    }

    @Override
    public void loadState(IMemento memento) {
        this.setName(memento.getString("name"));
        HashMap<String, IMemento> projectMementos = new HashMap<String, IMemento>();
        IMemento[] iMementoArray = memento.getChildren("project");
        int n = iMementoArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMemento iMemento = iMementoArray[n2];
            projectMementos.put(iMemento.getString("name"), iMemento);
            ++n2;
        }
        for (IWorkingSetProjectConfiguration iWorkingSetProjectConfiguration : this.getProjectConfigurations()) {
            IMemento state = (IMemento)projectMementos.get(iWorkingSetProjectConfiguration.getProjectName());
            if (state == null) continue;
            iWorkingSetProjectConfiguration.loadState(state);
        }
    }

    protected IWorkingSetProjectConfiguration createProjectConfiguration(IProject project) {
        IWorkingSetProjectConfiguration result = null;
        IWorkingSetProjectConfigurationFactory factory = IWorkingSetProjectConfigurationFactory.Registry.INSTANCE.getFactory(project);
        if (factory != null) {
            result = factory.createProjectConfiguration(this, project);
        }
        return result;
    }

    @Override
    public IWorkingSetConfiguration.ISnapshot createSnapshot(IWorkingSetProxy.ISnapshot workingSet, WorkspaceSnapshot workspace) {
        return new Snapshot((IWorkingSetProxy)workingSet, this, workspace);
    }

    static boolean isReadOnly(IWorkingSetConfiguration config) {
        return config instanceof Snapshot && ((Snapshot)config).isReadOnly();
    }

    public static class Snapshot
    extends WorkingSetConfiguration
    implements IWorkingSetConfiguration.ISnapshot {
        private final boolean readOnly;
        private final WorkspaceSnapshot workspace;

        protected Snapshot(IWorkingSetProxy workingSet, WorkspaceSnapshot workspace) {
            this(workingSet, workspace, false);
        }

        protected Snapshot(IWorkingSetProxy workingSet, WorkspaceSnapshot workspace, boolean readOnly) {
            super(workingSet);
            this.readOnly = readOnly;
            this.workspace = workspace;
        }

        protected Snapshot(IWorkingSetProxy workingSet, IWorkingSetConfiguration config, WorkspaceSnapshot workspace) {
            this(workingSet, workspace);
            this.setName(config.getName());
            for (IWorkingSetProjectConfiguration next : config.getProjectConfigurations()) {
                this.basicAddProjectConfiguration(next.createSnapshot(this, workspace));
            }
        }

        @Override
        public final IWorkingSetProxy.ISnapshot getWorkingSet() {
            return (IWorkingSetProxy.ISnapshot)super.getWorkingSet();
        }

        @Override
        public final WorkspaceSnapshot getWorkspaceSnapshot() {
            return this.workspace;
        }

        @Override
        public final boolean isReadOnly() {
            return this.readOnly;
        }

        @Override
        public void setName(String name) {
            super.setName(name);
        }

        @Override
        protected IWorkingSetProjectConfiguration createProjectConfiguration(IProject project) {
            IWorkingSetProjectConfiguration.ISnapshot result = null;
            IWorkingSetProjectConfigurationFactory factory = IWorkingSetProjectConfigurationFactory.Registry.INSTANCE.getFactory(project);
            if (factory != null) {
                result = factory.createProjectConfiguration(this, project).createSnapshot(this, this.workspace);
            }
            return result;
        }
    }
}

