/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.rpm.ui.editor.actions;

import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.linuxtools.internal.rpm.ui.editor.RPMHandlerUtils;
import org.eclipse.linuxtools.internal.rpm.ui.editor.RPMUtils;
import org.eclipse.linuxtools.internal.rpm.ui.editor.SpecfileLog;
import org.eclipse.linuxtools.internal.rpm.ui.editor.UiUtils;
import org.eclipse.linuxtools.internal.rpm.ui.editor.actions.Messages;
import org.eclipse.linuxtools.internal.rpm.ui.editor.parser.SpecfileSource;
import org.eclipse.linuxtools.rpm.core.RPMProject;
import org.eclipse.linuxtools.rpm.core.utils.DownloadJob;
import org.eclipse.linuxtools.rpm.ui.editor.parser.Specfile;
import org.eclipse.linuxtools.rpm.ui.editor.parser.SpecfileParser;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;
import org.eclipse.ui.handlers.HandlerUtil;

public class SpecfileEditorPrepareSourcesActionDelegate
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IFile workFile;
        Specfile specfile;
        final Shell shell = HandlerUtil.getActiveShellChecked((ExecutionEvent)event);
        SpecfileParser specparser = new SpecfileParser();
        IResource resource = RPMHandlerUtils.getResource(event);
        final RPMProject rpj = RPMHandlerUtils.getRPMProject(resource);
        if (!this.downloadFile(shell, rpj, specfile = specparser.parse(workFile = (IFile)rpj.getSpecFile()))) {
            return null;
        }
        Job job = new Job("Preparing sources"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected IStatus run(IProgressMonitor monitor) {
                monitor.beginTask(NLS.bind((String)Messages.PrepareSources_prepareSources, (Object)rpj.getSpecFile().getName()), -1);
                int offset = rpj.getSpecFile().getName().lastIndexOf(".");
                MessageConsoleStream out = SpecfileEditorPrepareSourcesActionDelegate.this.getConsole(rpj.getSpecFile().getName().substring(0, offset)).newMessageStream();
                IStatus is = null;
                try {
                    is = rpj.buildPrep((OutputStream)out);
                }
                catch (CoreException e) {
                    SpecfileLog.logError(Messages.PrepareSources_coreException, e);
                    RPMUtils.showErrorDialog(shell, Messages.PrepareSources_error, Messages.PrepareSources_coreException);
                    IStatus iStatus = is;
                    return iStatus;
                }
                finally {
                    monitor.done();
                }
                return is;
            }
        };
        job.setUser(true);
        job.schedule();
        return null;
    }

    public boolean downloadFile(Shell shell, RPMProject rpj, Specfile specfile) {
        List<SpecfileSource> sourceURLList = specfile != null ? specfile.getSources() : null;
        for (SpecfileSource sourceurls : sourceURLList) {
            try {
                String resolvedURL = UiUtils.resolveDefines(specfile, sourceurls.getFileName());
                URL url = null;
                try {
                    url = new URL(resolvedURL);
                }
                catch (MalformedURLException e) {
                    SpecfileLog.logError(NLS.bind((String)Messages.PrepareSources_downloadSourcesMalformedURL, (Object)resolvedURL), e);
                    RPMUtils.showErrorDialog(shell, Messages.PrepareSources_error, NLS.bind((String)Messages.PrepareSources_downloadSourcesMalformedURL, (Object)resolvedURL));
                    return false;
                }
                URLConnection connection = url.openConnection();
                if (connection instanceof HttpURLConnection && ((HttpURLConnection)connection).getResponseCode() == 404) continue;
                connection.connect();
                int offset = url.toString().lastIndexOf("/");
                String filename = url.toString().substring(offset + 1);
                IFile file = rpj.getConfiguration().getSourcesFolder().getFile((IPath)new Path(filename));
                DownloadJob downloadJob = new DownloadJob(file, connection);
                downloadJob.setUser(true);
                downloadJob.schedule();
                try {
                    downloadJob.join();
                }
                catch (InterruptedException e1) {
                    return false;
                }
                if (downloadJob.getResult().isOK()) continue;
                return false;
            }
            catch (OperationCanceledException e) {
                SpecfileLog.logError(Messages.PrepareSources_downloadCancelled, e);
                RPMUtils.showErrorDialog(shell, Messages.PrepareSources_error, Messages.PrepareSources_downloadCancelled);
                return false;
            }
            catch (IOException e) {
                SpecfileLog.logError(Messages.PrepareSources_downloadConnectionFail, e);
                RPMUtils.showErrorDialog(shell, Messages.PrepareSources_error, Messages.PrepareSources_downloadConnectionFail);
                return false;
            }
        }
        return true;
    }

    public MessageConsole getConsole(String packageName) {
        ConsolePlugin plugin = ConsolePlugin.getDefault();
        IConsoleManager conMan = plugin.getConsoleManager();
        String projectConsoleName = NLS.bind((String)Messages.PrepareSources_consoleName, (Object)packageName);
        MessageConsole ret = null;
        for (IConsole cons : ConsolePlugin.getDefault().getConsoleManager().getConsoles()) {
            if (!cons.getName().equals(projectConsoleName)) continue;
            ret = (MessageConsole)cons;
        }
        if (ret == null) {
            ret = new MessageConsole(projectConsoleName, null, null, true);
        }
        conMan.addConsoles(new IConsole[]{ret});
        ret.clearConsole();
        ret.activate();
        return ret;
    }
}

