/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.merge;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.CompareViewerPane;
import org.eclipse.compare.IResourceProvider;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.contentmergeviewer.ContentMergeViewer;
import org.eclipse.compare.structuremergeviewer.DiffContainer;
import org.eclipse.compare.structuremergeviewer.DiffNode;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.compare.structuremergeviewer.IDiffContainer;
import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.egit.core.info.GitInfo;
import org.eclipse.egit.core.internal.efs.HiddenResources;
import org.eclipse.egit.core.internal.indexdiff.IndexDiffCache;
import org.eclipse.egit.core.internal.indexdiff.IndexDiffCacheEntry;
import org.eclipse.egit.core.internal.util.ResourceUtil;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.CompareUtils;
import org.eclipse.egit.ui.internal.UIIcons;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.merge.CompareEditorInputViewerAction;
import org.eclipse.egit.ui.internal.merge.CompareWithEachOtherAction;
import org.eclipse.egit.ui.internal.merge.GitDiffTreeViewer;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.team.internal.ui.synchronize.EditableSharedDocumentAdapter;
import org.eclipse.team.internal.ui.synchronize.LocalResourceTypedElement;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.IHandlerActivation;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.part.IShowInSource;
import org.eclipse.ui.part.ShowInContext;
import org.eclipse.ui.services.IServiceLocator;

public abstract class AbstractGitCompareEditorInput
extends CompareEditorInput {
    private static final Comparator<String> CMP = (left, right) -> {
        String l = left.startsWith("/") ? left.substring(1) : left;
        String r = right.startsWith("/") ? right.substring(1) : right;
        return l.replace('/', '\u0001').compareToIgnoreCase(r.replace('/', '\u0001'));
    };
    private static final Image FOLDER_IMAGE = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
    private static final Image PROJECT_IMAGE = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_PROJECT");
    private final IPath[] locations;
    private List<IFile> toDelete;
    private Map<String, IHandlerActivation> activations = new HashMap<String, IHandlerActivation>();
    private Repository repository;
    private Collection<String> gitPaths;
    private boolean initialized;

    protected AbstractGitCompareEditorInput(Repository repository, IPath ... locations) {
        super(new CompareConfiguration());
        this.repository = repository;
        this.locations = locations;
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (!(adapter != IFile.class && adapter != IResource.class || this.isMultiFile())) {
            ITypedElement element = this.getElement();
            IResource resource = this.getResource(element);
            if (resource != null && adapter.isInstance(resource) && resource.exists()) {
                return adapter.cast(resource);
            }
        } else {
            if (adapter == IShowInSource.class && this.isMultiFile()) {
                DiffNode node = this.getNode();
                if (node instanceof FolderNode) {
                    FolderNode folder = (FolderNode)node;
                    IContainer container = folder.getContainer();
                    if (container != null) {
                        return adapter.cast(this.getShowInSource(new ShowInContext((Object)this, (ISelection)new StructuredSelection((Object)container))));
                    }
                    IPath path = folder.getPath();
                    if (path != null) {
                        if (path.isAbsolute()) {
                            return adapter.cast(this.getShowInSource(new ShowInContext((Object)this, (ISelection)new StructuredSelection((Object)path))));
                        }
                        GitInfo info = this.getGitInfo(path);
                        if (info != null) {
                            return adapter.cast(this.getShowInSource(new ShowInContext((Object)this, (ISelection)new StructuredSelection((Object)info))));
                        }
                    }
                } else if (node != null) {
                    ITypedElement element = node.getLeft();
                    IResource resource = this.getResource(element);
                    if (resource instanceof IFile && resource.exists()) {
                        return adapter.cast(this.getShowInSource(new ShowInContext((Object)this, (ISelection)new StructuredSelection((Object)resource))));
                    }
                    GitInfo info = (GitInfo)Adapters.adapt((Object)element, GitInfo.class);
                    if (info != null && info.getRepository() != null) {
                        File f;
                        IPath path = Path.fromPortableString((String)info.getGitPath());
                        if (!this.repository.isBare() && (f = new File(this.repository.getWorkTree(), path.toOSString())).exists()) {
                            return adapter.cast(this.getShowInSource(new ShowInContext((Object)this, (ISelection)new StructuredSelection((Object)Path.fromOSString((String)f.getAbsolutePath())))));
                        }
                        return adapter.cast(this.getShowInSource(new ShowInContext((Object)this, (ISelection)new StructuredSelection((Object)info))));
                    }
                }
                return adapter.cast(this.getShowInSource(null));
            }
            if (adapter == Repository.class) {
                return adapter.cast(this.repository);
            }
        }
        return (T)super.getAdapter(adapter);
    }

    public Object getSelectedEdition() {
        if (AbstractGitCompareEditorInput.isUIThread()) {
            return super.getSelectedEdition();
        }
        Object[] item = new Object[1];
        PlatformUI.getWorkbench().getDisplay().syncExec(() -> {
            objectArray[0] = super.getSelectedEdition();
        });
        return item[0];
    }

    private boolean isMultiFile() {
        Object input = this.getCompareResult();
        if (input instanceof IDiffContainer) {
            IDiffElement[] children = ((IDiffContainer)input).getChildren();
            if (children.length != 1) {
                return true;
            }
            if (children[0] instanceof IDiffContainer && ((IDiffContainer)children[0]).hasChildren()) {
                return true;
            }
        }
        return false;
    }

    private ITypedElement getElement() {
        Object selectedEdition = this.getSelectedEdition();
        if (selectedEdition instanceof DiffNode) {
            DiffNode diffNode = (DiffNode)selectedEdition;
            return diffNode.getLeft();
        }
        return null;
    }

    private DiffNode getNode() {
        Object selectedEdition = this.getSelectedEdition();
        if (selectedEdition instanceof DiffNode) {
            return (DiffNode)selectedEdition;
        }
        return null;
    }

    private IResource getResource(ITypedElement element) {
        if (element != null) {
            IFile resource = null;
            if (element instanceof HiddenResourceTypedElement) {
                resource = ((HiddenResourceTypedElement)element).getRealFile();
            } else if (element instanceof IResourceProvider) {
                resource = ((IResourceProvider)element).getResource();
            }
            return resource;
        }
        return null;
    }

    protected GitInfo getGitInfo(IPath path) {
        return null;
    }

    private IShowInSource getShowInSource(ShowInContext context) {
        return () -> context;
    }

    protected void contentsCreated() {
        super.contentsCreated();
        this.getNavigator().selectChange(true);
    }

    public Viewer createDiffViewer(Composite parent) {
        GitDiffTreeViewer viewer = new GitDiffTreeViewer(parent, this.getContainer(), this.getCompareConfiguration());
        viewer.setComparator(new ViewerComparator(CMP){

            public int category(Object element) {
                if (element instanceof FolderNode) {
                    return 0;
                }
                return 1;
            }
        });
        CompareWithEachOtherAction compareAction = new CompareWithEachOtherAction(viewer, UIText.GitMergeEditorInput_CompareWithEachOtherMenuLabel, UIIcons.ELCL16_COMPARE_VIEW);
        viewer.setActions(Collections.singleton(compareAction));
        this.registerAction((IAction)compareAction, "org.eclipse.egit.ui.CompareWithEachOther");
        return viewer;
    }

    public Viewer findContentViewer(Viewer oldViewer, ICompareInput input, Composite parent) {
        Viewer newViewer = super.findContentViewer(oldViewer, input, parent);
        ToolBarManager manager = CompareViewerPane.getToolBarManager((Composite)parent);
        if (manager != null) {
            this.initActions(manager, newViewer, input);
        }
        return newViewer;
    }

    protected void initActions(ToolBarManager manager, Viewer newViewer, ICompareInput input) {
    }

    protected void setAction(ToolBarManager manager, Viewer viewer, boolean isApplicable, String id, ActionSupplier supplier) {
        IContributionItem item = manager.find(id);
        if (item != null) {
            IAction action;
            if (item instanceof ActionContributionItem && (action = ((ActionContributionItem)item).getAction()) instanceof CompareEditorInputViewerAction) {
                ((CompareEditorInputViewerAction)action).setViewer(isApplicable ? (ContentMergeViewer)viewer : null);
                action.setEnabled(isApplicable);
                if (item.isVisible() != isApplicable) {
                    item.setVisible(isApplicable);
                    manager.update(true);
                }
            }
        } else if (isApplicable) {
            CompareEditorInputViewerAction action = supplier.get(true);
            action.setViewer((ContentMergeViewer)viewer);
            action.setEnabled(true);
            manager.insert(0, (IContributionItem)new ActionContributionItem((IAction)action));
            manager.update(true);
            this.registerAction((IAction)action, id);
        } else {
            CompareEditorInputViewerAction action = supplier.get(false);
            if (action != null) {
                action.setEnabled(false);
            }
        }
    }

    private void registerAction(IAction action, String commandId) {
        IHandlerService handlers;
        if (this.activations.containsKey(commandId)) {
            return;
        }
        action.setActionDefinitionId(commandId);
        IServiceLocator locator = this.getContainer().getServiceLocator();
        if (locator != null && (handlers = (IHandlerService)locator.getService(IHandlerService.class)) != null) {
            this.activations.put(commandId, handlers.activateHandler(commandId, (IHandler)new ActionHandler(action)));
        }
    }

    protected void disposeActions() {
    }

    protected void handleDispose() {
        super.handleDispose();
        this.activations.values().forEach(a -> a.getHandlerService().deactivateHandler(a));
        this.activations.clear();
        this.disposeActions();
        PlatformUI.getWorkbench().getDisplay().asyncExec(this::cleanUp);
    }

    private void cleanUp() {
        List<IFile> toClean = this.toDelete;
        this.toDelete = null;
        CompareUtils.cleanHiddenResources(toClean);
    }

    private static boolean isUIThread() {
        return Display.getCurrent() != null;
    }

    protected LocalResourceTypedElement createWithHiddenResource(URI uri, Repository repo, String gitPath, String name, IFile file, Charset encoding) throws IOException {
        IFile tmp = this.createHiddenResource(uri, name, encoding);
        return new HiddenResourceTypedElement(repo, gitPath, tmp, file);
    }

    protected IFile createHiddenResource(URI uri, String name, Charset encoding) throws IOException {
        try {
            IFile tmp = HiddenResources.INSTANCE.createFile(uri, name, encoding, null);
            if (this.toDelete == null) {
                this.toDelete = new ArrayList<IFile>();
            }
            this.toDelete.add(tmp);
            return tmp;
        }
        catch (CoreException e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    protected IDiffContainer getFileParent(IDiffContainer root, IPath repositoryPath, IFile file, IPath location) {
        IProject project;
        IPath projectLocation;
        int projectSegment = -1;
        String projectName = null;
        if (file != null && (projectLocation = (project = file.getProject()).getLocation()) != null) {
            IPath projectPath = project.getLocation().makeRelativeTo(repositoryPath);
            projectSegment = projectPath.segmentCount() - 1;
            projectName = project.getName();
        }
        IPath path = location.makeRelativeTo(repositoryPath);
        int pathLength = path.segmentCount() - 1;
        IDiffContainer child = root;
        int i = 0;
        while (i < pathLength) {
            child = i == projectSegment ? this.getOrCreateChild(child, projectName, true) : this.getOrCreateChild(child, path.segment(i), false);
            ++i;
        }
        if (child != root) {
            IContainer container = file != null ? file.getParent() : null;
            path = location.removeLastSegments(1);
            IDiffContainer folder = child;
            while (folder != root) {
                if (folder instanceof FolderNode) {
                    if (container != null) {
                        ((FolderNode)folder).setContainer(container);
                        if (container.isLinked()) {
                            container = null;
                        } else if ((container = container.getParent()).getType() == 8) {
                            container = null;
                        }
                    } else if (path != null) {
                        ((FolderNode)folder).setPath(path);
                    }
                    if (path == null || pathLength <= 0) break;
                    path = path.removeLastSegments(1);
                    --pathLength;
                }
                folder = folder.getParent();
            }
        }
        return child;
    }

    protected IDiffContainer getFileParent(IDiffContainer root, String gitPath) {
        IDiffContainer child = root;
        IPath path = Path.fromPortableString((String)gitPath);
        int pathLength = path.segmentCount() - 1;
        int i = 0;
        while (i < pathLength) {
            child = this.getOrCreateChild(child, path.segment(i), false);
            ++i;
        }
        if (child != root) {
            if (!this.repository.isBare()) {
                path = Path.fromOSString((String)this.repository.getWorkTree().getAbsolutePath()).append(path);
            }
            path = path.removeLastSegments(1);
            IDiffContainer folder = child;
            while (folder != root) {
                if (folder instanceof FolderNode) {
                    if (pathLength <= 0) break;
                    ((FolderNode)folder).setPath(path);
                    path = path.removeLastSegments(1);
                    --pathLength;
                }
                folder = folder.getParent();
            }
        }
        return child;
    }

    private DiffNode getOrCreateChild(IDiffContainer parent, String name, boolean projectMode) {
        IDiffElement[] iDiffElementArray = parent.getChildren();
        int n = iDiffElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IDiffElement child = iDiffElementArray[n2];
            if (child.getName().equals(name)) {
                return (DiffNode)child;
            }
            ++n2;
        }
        return new FolderNode(parent, name, projectMode ? PROJECT_IMAGE : FOLDER_IMAGE);
    }

    private void collapse(DiffContainer top) {
        boolean isRoot;
        IDiffElement[] children = top.getChildren();
        boolean bl = isRoot = top.getParent() == null;
        if (!isRoot) {
            while (children != null && children.length == 1) {
                IDiffElement singleChild = children[0];
                if (singleChild instanceof FolderNode) {
                    FolderNode node = (FolderNode)singleChild;
                    top.remove(singleChild);
                    top.getParent().add(singleChild);
                    node.setName(top.getName() + "/" + singleChild.getName());
                    ((DiffContainer)top.getParent()).remove((IDiffElement)top);
                    children = node.getChildren();
                    top = node;
                    continue;
                }
                return;
            }
        }
        if (children != null && (isRoot || children.length > 1)) {
            IDiffElement[] iDiffElementArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                IDiffElement node = iDiffElementArray[n2];
                if (node instanceof FolderNode) {
                    this.collapse((DiffContainer)node);
                }
                ++n2;
            }
        }
    }

    public boolean canRunAsJob() {
        return true;
    }

    protected final Object prepareInput(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        monitor.beginTask(UIText.GitMergeEditorInput_CheckingResourcesTaskName, -1);
        try {
            this.initPaths();
            if (monitor.isCanceled()) {
                throw new InterruptedException();
            }
            DiffContainer result = this.buildInput(monitor);
            if (result != null) {
                this.collapse(result);
            }
            this.inputBuilt(result);
            DiffContainer diffContainer = result;
            return diffContainer;
        }
        finally {
            monitor.done();
        }
    }

    protected abstract DiffContainer buildInput(IProgressMonitor var1) throws InvocationTargetException, InterruptedException;

    protected void inputBuilt(DiffContainer root) {
    }

    private void initPaths() throws InvocationTargetException {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        if (this.repository == null || this.locations != null && this.locations.length > 0) {
            Map pathsByRepository = ResourceUtil.splitPathsByRepository(Arrays.asList(this.locations));
            if (pathsByRepository.size() != 1) {
                throw new InvocationTargetException(new IllegalStateException(UIText.RepositoryAction_multiRepoSelection));
            }
            Map.Entry entry = pathsByRepository.entrySet().iterator().next();
            Repository repo = (Repository)entry.getKey();
            if (this.repository != null && !repo.getDirectory().equals(this.repository.getDirectory())) {
                throw new InvocationTargetException(new IllegalStateException("Paths not in repo " + String.valueOf(this.repository.getDirectory())));
            }
            if (this.repository == null) {
                this.repository = repo;
            }
            this.gitPaths = new ArrayList<String>((Collection)entry.getValue());
        }
    }

    public Repository getRepository() {
        return this.repository;
    }

    protected Collection<String> getFilterPaths() {
        if (this.gitPaths == null) {
            return Collections.emptyList();
        }
        return this.gitPaths;
    }

    public int hashCode() {
        return Arrays.hashCode(this.locations);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        AbstractGitCompareEditorInput other = (AbstractGitCompareEditorInput)((Object)obj);
        return Arrays.equals(this.locations, other.locations);
    }

    @FunctionalInterface
    protected static interface ActionSupplier {
        public CompareEditorInputViewerAction get(boolean var1);
    }

    private static class FolderNode
    extends DiffNode {
        private final Image image;
        private String name;
        private IContainer container;
        private IPath path;

        FolderNode(IDiffContainer parent, String name, Image image) {
            super(parent, 0);
            this.name = name;
            this.image = image;
        }

        public String getType() {
            return "FOLDER";
        }

        public String getName() {
            return this.name;
        }

        void setName(String name) {
            this.name = name;
        }

        public Image getImage() {
            return this.image;
        }

        void setContainer(IContainer container) {
            this.container = container;
        }

        IContainer getContainer() {
            return this.container;
        }

        void setPath(IPath path) {
            this.path = path;
        }

        IPath getPath() {
            return this.path;
        }

        public boolean equals(Object other) {
            return super.equals(other);
        }

        public int hashCode() {
            return super.hashCode();
        }
    }

    protected static class HiddenResourceTypedElement
    extends LocalResourceTypedElement
    implements GitInfo {
        private final IFile realFile;
        private final Repository repository;
        private final String gitPath;

        private HiddenResourceTypedElement(Repository repository, String gitPath, IFile file, IFile realFile) {
            super((IResource)file);
            this.realFile = realFile;
            this.repository = repository;
            this.gitPath = gitPath;
        }

        public IFile getRealFile() {
            return this.realFile;
        }

        public boolean equals(Object obj) {
            return super.equals(obj);
        }

        public int hashCode() {
            return super.hashCode();
        }

        public Repository getRepository() {
            return this.repository;
        }

        public String getGitPath() {
            return this.gitPath;
        }

        public GitInfo.Source getSource() {
            return GitInfo.Source.WORKING_TREE;
        }

        public AnyObjectId getCommitId() {
            return null;
        }
    }

    protected static class LocalResourceSaver
    implements EditableSharedDocumentAdapter.ISharedDocumentAdapterListener {
        LocalResourceTypedElement element;

        public LocalResourceSaver(LocalResourceTypedElement element) {
            this.element = element;
        }

        protected void save() throws CoreException {
            this.element.saveDocument(true, null);
            this.refreshIndexDiff();
        }

        private void refreshIndexDiff() {
            IResource resource = this.element.getResource();
            if (resource != null && HiddenResources.INSTANCE.isHiddenProject((IResource)resource.getProject())) {
                IndexDiffCacheEntry indexDiffCacheForRepository;
                String gitPath = null;
                Repository repository = null;
                URI uri = resource.getLocationURI();
                if ("file".equals(uri.getScheme())) {
                    Path location = new Path(uri.getSchemeSpecificPart());
                    repository = ResourceUtil.getRepository((IPath)location);
                    if (repository != null && (location = ResourceUtil.getRepositoryRelativePath((IPath)location, (Repository)repository)) != null) {
                        gitPath = location.toPortableString();
                    }
                } else {
                    repository = HiddenResources.INSTANCE.getRepository(uri);
                    if (repository != null) {
                        gitPath = HiddenResources.INSTANCE.getGitPath(uri);
                    }
                }
                if (gitPath != null && repository != null && (indexDiffCacheForRepository = IndexDiffCache.INSTANCE.getIndexDiffCacheEntry(repository)) != null) {
                    indexDiffCacheForRepository.refreshFiles(Collections.singletonList(gitPath));
                }
            }
        }

        public void handleDocumentConnected() {
        }

        public void handleDocumentDisconnected() {
        }

        public void handleDocumentFlushed() {
            try {
                this.save();
            }
            catch (CoreException e) {
                Activator.handleStatus(e.getStatus(), true);
            }
        }

        public void handleDocumentDeleted() {
        }

        public void handleDocumentSaved() {
        }
    }
}

