/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.debug.internal.ui.actions;

import org.eclipse.cdt.core.IAddress;
import org.eclipse.cdt.debug.core.CDIDebugModel;
import org.eclipse.cdt.debug.core.model.IRunToAddress;
import org.eclipse.cdt.dsf.debug.internal.ui.disassembly.provisional.DisassemblySelection;
import org.eclipse.cdt.dsf.debug.internal.ui.disassembly.provisional.IDisassemblyPart;
import org.eclipse.cdt.dsf.debug.internal.ui.disassembly.provisional.IDisassemblySelection;
import org.eclipse.cdt.dsf.internal.ui.DsfUIPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.ISuspendResume;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.actions.IRunToLineTarget;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IWorkbenchPart;

public class DisassemblyRunToLineAdapter
implements IRunToLineTarget {
    public void runToLine(IWorkbenchPart part, ISelection selection, ISuspendResume target) throws CoreException {
        if (part instanceof IDisassemblyPart && selection instanceof ITextSelection) {
            IRunToAddress runToAddress;
            IDisassemblySelection disassemblySelection;
            IAddress address;
            if (!(selection instanceof IDisassemblySelection)) {
                selection = new DisassemblySelection((ITextSelection)selection, (IDisassemblyPart)part);
            }
            if ((address = (disassemblySelection = (IDisassemblySelection)selection).getStartAddress()) != null && target instanceof IAdaptable && (runToAddress = (IRunToAddress)((IAdaptable)target).getAdapter(IRunToAddress.class)) != null && runToAddress.canRunToAddress(address)) {
                try {
                    boolean skipBreakpoints = DebugUITools.getPreferenceStore().getBoolean("org.eclipse.debug.ui.skip_breakpoints_during_run_to_line");
                    runToAddress.runToAddress(address, skipBreakpoints);
                }
                catch (DebugException e) {
                    this.failed(e);
                }
            }
        }
    }

    public boolean canRunToLine(IWorkbenchPart part, ISelection selection, ISuspendResume target) {
        if (target instanceof IAdaptable && part instanceof IDisassemblyPart && selection instanceof ITextSelection) {
            IDisassemblySelection disassemblySelection;
            IAddress address;
            IRunToAddress runToAddress = (IRunToAddress)((IAdaptable)target).getAdapter(IRunToAddress.class);
            if (runToAddress == null) {
                return false;
            }
            if (!(selection instanceof IDisassemblySelection)) {
                selection = new DisassemblySelection((ITextSelection)selection, (IDisassemblyPart)part);
            }
            if ((address = (disassemblySelection = (IDisassemblySelection)selection).getStartAddress()) == null) {
                return false;
            }
            return runToAddress.canRunToAddress(address);
        }
        return false;
    }

    protected void failed(Throwable e) {
        MultiStatus ms = new MultiStatus(CDIDebugModel.getPluginIdentifier(), 10004, "RunToLine failed", null);
        ms.add((IStatus)new Status(4, CDIDebugModel.getPluginIdentifier(), 10004, e.getMessage(), e));
        DsfUIPlugin.log((IStatus)ms);
    }
}

