/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.settings;

import org.eclipse.lemminx.settings.capabilities.CompletionResolveSupportProperty;
import org.eclipse.lsp4j.CompletionCapabilities;

public class XMLCompletionSettings {
    private CompletionCapabilities completionCapabilities;
    private boolean autoCloseTags;
    private boolean autoCloseRemovesContent;

    public XMLCompletionSettings(boolean autoCloseTags, boolean autoCloseRemovesContent) {
        this.autoCloseTags = autoCloseTags;
        this.autoCloseRemovesContent = autoCloseRemovesContent;
    }

    public XMLCompletionSettings() {
        this(true, true);
    }

    public void setCapabilities(CompletionCapabilities completionCapabilities) {
        this.completionCapabilities = completionCapabilities;
    }

    public CompletionCapabilities getCompletionCapabilities() {
        return this.completionCapabilities;
    }

    public void setAutoCloseTags(boolean autoCloseTags) {
        this.autoCloseTags = autoCloseTags;
    }

    public boolean isAutoCloseTags() {
        return this.autoCloseTags;
    }

    public void setAutoCloseRemovesContent(boolean autoCloseRemovesContent) {
        this.autoCloseRemovesContent = autoCloseRemovesContent;
    }

    public boolean isAutoCloseRemovesContent() {
        return this.autoCloseRemovesContent;
    }

    public boolean isCompletionSnippetsSupported() {
        return this.completionCapabilities != null && this.completionCapabilities.getCompletionItem() != null && this.completionCapabilities.getCompletionItem().getSnippetSupport() != null && this.completionCapabilities.getCompletionItem().getSnippetSupport() != false;
    }

    public boolean isCompletionResolveSupported(CompletionResolveSupportProperty property) {
        return this.completionCapabilities != null && this.completionCapabilities.getCompletionItem() != null && this.completionCapabilities.getCompletionItem().getResolveSupport() != null && this.completionCapabilities.getCompletionItem().getResolveSupport().getProperties() != null && this.completionCapabilities.getCompletionItem().getResolveSupport().getProperties().contains(property.name());
    }

    public boolean isCompletionListItemDefaultsSupport(String field) {
        return this.completionCapabilities != null && this.completionCapabilities.getCompletionList() != null && this.completionCapabilities.getCompletionList().getItemDefaults() != null && this.completionCapabilities.getCompletionList().getItemDefaults().contains(field);
    }

    public void merge(XMLCompletionSettings newCompletion) {
        this.setAutoCloseTags(newCompletion.isAutoCloseTags());
        this.setAutoCloseRemovesContent(newCompletion.isAutoCloseRemovesContent());
    }
}

