/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.engine.discovery;

import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.junit.platform.engine.FilterResult;
import org.junit.platform.engine.discovery.AbstractClassNameFilter;

class ExcludeClassNameFilter
extends AbstractClassNameFilter {
    ExcludeClassNameFilter(String ... patterns) {
        super(patterns);
    }

    @Override
    public FilterResult apply(String className) {
        return this.findMatchingPattern(className).map(pattern -> FilterResult.excluded(this.formatExclusionReason(className, (Pattern)pattern))).orElseGet(() -> FilterResult.included(this.formatInclusionReason(className)));
    }

    private String formatInclusionReason(String className) {
        return "Class name [%s] does not match any excluded pattern: %s".formatted(className, this.patternDescription);
    }

    private String formatExclusionReason(String className, Pattern pattern) {
        return "Class name [%s] matches excluded pattern: '%s'".formatted(className, pattern);
    }

    @Override
    public Predicate<String> toPredicate() {
        return className -> this.findMatchingPattern((String)className).isEmpty();
    }

    public String toString() {
        return "%s that excludes class names that match one of the following regular expressions: %s".formatted(this.getClass().getSimpleName(), this.patternDescription);
    }
}

