/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.core.model;

import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Type;
import com.sun.jdi.Value;
import java.text.MessageFormat;
import org.eclipse.debug.core.DebugException;
import org.eclipse.jdt.internal.debug.core.model.JDIDebugModelMessages;
import org.eclipse.jdt.internal.debug.core.model.JDIDebugTarget;
import org.eclipse.jdt.internal.debug.core.model.JDIVariable;

public class JDIThisVariable
extends JDIVariable {
    private final ObjectReference fObject;

    public JDIThisVariable(JDIDebugTarget target, ObjectReference object) {
        super(target);
        this.fObject = object;
    }

    @Override
    protected Value retrieveValue() {
        return this.fObject;
    }

    public String getName() {
        return "this";
    }

    @Override
    public String getSignature() throws DebugException {
        try {
            return this.retrieveValue().type().signature();
        }
        catch (RuntimeException e) {
            this.targetRequestFailed(MessageFormat.format(JDIDebugModelMessages.JDIThisVariableexception_retrieving_type_signature, e.toString()), e);
            return null;
        }
    }

    @Override
    public String getGenericSignature() throws DebugException {
        return this.getSignature();
    }

    public String getReferenceTypeName() throws DebugException {
        try {
            return this.getValue().getReferenceTypeName();
        }
        catch (RuntimeException e) {
            this.targetRequestFailed(MessageFormat.format(JDIDebugModelMessages.JDIThisVariableexception_retrieving_reference_type_name, e.toString()), e);
            return null;
        }
    }

    @Override
    protected Type getUnderlyingType() throws DebugException {
        try {
            return this.retrieveValue().type();
        }
        catch (RuntimeException e) {
            this.targetRequestFailed(MessageFormat.format(JDIDebugModelMessages.JDIThisVariable_exception_while_retrieving_type_this, e.toString()), e);
            return null;
        }
    }

    @Override
    public boolean isPrivate() throws DebugException {
        try {
            return ((ReferenceType)this.getUnderlyingType()).isPrivate();
        }
        catch (RuntimeException e) {
            this.targetRequestFailed(JDIDebugModelMessages.JDIThisVariable_Exception_occurred_while_retrieving_modifiers__1, e);
            return false;
        }
    }

    @Override
    public boolean isProtected() throws DebugException {
        try {
            return ((ReferenceType)this.getUnderlyingType()).isProtected();
        }
        catch (RuntimeException e) {
            this.targetRequestFailed(JDIDebugModelMessages.JDIThisVariable_Exception_occurred_while_retrieving_modifiers__1, e);
            return false;
        }
    }

    @Override
    public boolean isPublic() throws DebugException {
        try {
            return ((ReferenceType)this.getUnderlyingType()).isPublic();
        }
        catch (RuntimeException e) {
            this.targetRequestFailed(JDIDebugModelMessages.JDIThisVariable_Exception_occurred_while_retrieving_modifiers__1, e);
            return false;
        }
    }

    public boolean equals(Object o) {
        if (o instanceof JDIThisVariable) {
            return ((JDIThisVariable)o).fObject.equals(this.fObject);
        }
        return false;
    }

    public int hashCode() {
        return this.fObject.hashCode();
    }
}

