/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.ui.internal.markers;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.quickassist.IQuickAssistInvocationContext;
import org.eclipse.m2e.core.ui.internal.markers.MavenProblemResolution;

public abstract class EditorAwareMavenProblemResolution
extends MavenProblemResolution {
    private IQuickAssistInvocationContext context;

    protected EditorAwareMavenProblemResolution(IMarker marker) {
        super(marker);
    }

    public IQuickAssistInvocationContext getQuickAssistContext() {
        return this.context;
    }

    public void setQuickAssistContext(IQuickAssistInvocationContext context) {
        this.context = context;
    }

    @Override
    protected final void fix(IMarker[] markers, IDocument document, IProgressMonitor monitor) {
        Map<IResource, List<IMarker>> resourceMap = Stream.of(markers).collect(Collectors.groupingBy(IMarker::getResource));
        if (resourceMap.size() == 1 && document != null) {
            this.fix(document, resourceMap.values().iterator().next(), monitor);
            return;
        }
        for (Map.Entry<IResource, List<IMarker>> e : resourceMap.entrySet()) {
            this.fix(e.getKey(), e.getValue(), monitor);
        }
    }

    protected abstract void fix(IResource var1, List<IMarker> var2, IProgressMonitor var3);

    protected abstract void fix(IDocument var1, List<IMarker> var2, IProgressMonitor var3);
}

