/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.commons.util;

import java.util.ServiceLoader;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.apiguardian.api.API;
import org.junit.platform.commons.util.Preconditions;

@API(status=API.Status.INTERNAL, since="1.11")
public class ServiceLoaderUtils {
    private ServiceLoaderUtils() {
    }

    public static <T> Stream<T> filter(ServiceLoader<T> serviceLoader, Predicate<? super Class<? extends T>> providerPredicate) {
        Preconditions.notNull(serviceLoader, "serviceLoader must not be null");
        Preconditions.notNull(providerPredicate, "providerPredicate must not be null");
        return serviceLoader.stream().filter(provider -> providerPredicate.test(provider.type())).map(ServiceLoader.Provider::get);
    }
}

