/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.commons.util;

import java.util.Arrays;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import org.apiguardian.api.API;
import org.jspecify.annotations.Nullable;
import org.junit.platform.commons.annotation.Contract;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.commons.util.UnrecoverableExceptions;

@API(status=API.Status.INTERNAL, since="1.0")
public final class StringUtils {
    private static final Pattern ISO_CONTROL_PATTERN = StringUtils.compileIsoControlPattern();
    private static final Pattern WHITESPACE_PATTERN = Pattern.compile("\\s");

    static Pattern compileIsoControlPattern() {
        try {
            return Pattern.compile("\\p{Cntrl}", 256);
        }
        catch (IllegalArgumentException e) {
            return Pattern.compile("\\p{Cntrl}");
        }
    }

    private StringUtils() {
    }

    @Contract(value="null -> true")
    public static boolean isBlank(@Nullable String str) {
        return str == null || str.isBlank();
    }

    @Contract(value="null -> false")
    public static boolean isNotBlank(@Nullable String str) {
        return !StringUtils.isBlank(str);
    }

    @Contract(value="null -> false")
    public static boolean containsWhitespace(@Nullable String str) {
        return str != null && str.codePoints().anyMatch(Character::isWhitespace);
    }

    @Contract(value="null -> true")
    public static boolean doesNotContainWhitespace(@Nullable String str) {
        return !StringUtils.containsWhitespace(str);
    }

    @Contract(value="null -> false")
    public static boolean containsIsoControlCharacter(@Nullable String str) {
        return str != null && str.codePoints().anyMatch(Character::isISOControl);
    }

    @Contract(value="null -> true")
    public static boolean doesNotContainIsoControlCharacter(@Nullable String str) {
        return !StringUtils.containsIsoControlCharacter(str);
    }

    public static String nullSafeToString(@Nullable Object obj) {
        if (obj == null) {
            return "null";
        }
        try {
            if (obj.getClass().isArray()) {
                if (obj.getClass().getComponentType().isPrimitive()) {
                    if (obj instanceof boolean[]) {
                        boolean[] booleans = (boolean[])obj;
                        return Arrays.toString(booleans);
                    }
                    if (obj instanceof char[]) {
                        char[] chars = (char[])obj;
                        return Arrays.toString(chars);
                    }
                    if (obj instanceof short[]) {
                        short[] shorts = (short[])obj;
                        return Arrays.toString(shorts);
                    }
                    if (obj instanceof byte[]) {
                        byte[] bytes = (byte[])obj;
                        return Arrays.toString(bytes);
                    }
                    if (obj instanceof int[]) {
                        int[] ints = (int[])obj;
                        return Arrays.toString(ints);
                    }
                    if (obj instanceof long[]) {
                        long[] longs = (long[])obj;
                        return Arrays.toString(longs);
                    }
                    if (obj instanceof float[]) {
                        float[] floats = (float[])obj;
                        return Arrays.toString(floats);
                    }
                    if (obj instanceof double[]) {
                        double[] doubles = (double[])obj;
                        return Arrays.toString(doubles);
                    }
                }
                return Arrays.deepToString((Object[])obj);
            }
            String result = obj.toString();
            return result != null ? result : "null";
        }
        catch (Throwable throwable) {
            UnrecoverableExceptions.rethrowIfUnrecoverable(throwable);
            return StringUtils.defaultToString(obj);
        }
    }

    public static String defaultToString(@Nullable Object obj) {
        if (obj == null) {
            return "null";
        }
        return obj.getClass().getName() + "@" + Integer.toHexString(System.identityHashCode(obj));
    }

    @API(status=API.Status.INTERNAL, since="1.4")
    @Contract(value="null, _ -> null; !null, _ -> !null")
    public static @Nullable String replaceIsoControlCharacters(@Nullable String str, String replacement) {
        Preconditions.notNull(replacement, "replacement must not be null");
        return str == null ? null : ISO_CONTROL_PATTERN.matcher(str).replaceAll(replacement);
    }

    @API(status=API.Status.INTERNAL, since="1.4")
    @Contract(value="null, _ -> null; !null, _ -> !null")
    public static @Nullable String replaceWhitespaceCharacters(@Nullable String str, String replacement) {
        Preconditions.notNull(replacement, "replacement must not be null");
        return str == null ? null : WHITESPACE_PATTERN.matcher(str).replaceAll(replacement);
    }

    @API(status=API.Status.INTERNAL, since="1.11")
    public static TwoPartSplitResult splitIntoTwo(char separator, String value) {
        Preconditions.notNull(value, "value must not be null");
        return StringUtils.splitIntoTwo(value, value.indexOf(separator), 1);
    }

    @API(status=API.Status.INTERNAL, since="1.11")
    public static TwoPartSplitResult splitIntoTwo(String separator, String value) {
        Preconditions.notNull(separator, "separator must not be null");
        Preconditions.notNull(value, "value must not be null");
        return StringUtils.splitIntoTwo(value, value.indexOf(separator), separator.length());
    }

    private static TwoPartSplitResult splitIntoTwo(String value, int index, int length) {
        if (index == -1) {
            return new OnePart(value);
        }
        return new TwoParts(value.substring(0, index), value.substring(index + length));
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    @API(status=API.Status.INTERNAL, since="1.11")
    public static interface TwoPartSplitResult {
        default public <T> T mapTwo(Supplier<? extends RuntimeException> onePartExceptionCreator, BiFunction<String, String, ? extends T> twoPartsMapper) {
            Function<String, Object> onePartMapper = __ -> {
                throw (RuntimeException)onePartExceptionCreator.get();
            };
            return this.map(onePartMapper, twoPartsMapper);
        }

        public <T> T map(Function<String, ? extends T> var1, BiFunction<String, String, ? extends T> var2);
    }

    private record OnePart(String value) implements TwoPartSplitResult
    {
        @Override
        public <T> T map(Function<String, ? extends T> onePartMapper, BiFunction<String, String, ? extends T> twoPartsMapper) {
            return onePartMapper.apply(this.value);
        }
    }

    private record TwoParts(String first, String second) implements TwoPartSplitResult
    {
        @Override
        public <T> T map(Function<String, ? extends T> onePartMapper, BiFunction<String, String, ? extends T> twoPartsMapper) {
            return twoPartsMapper.apply(this.first, this.second);
        }
    }
}

