/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.core.externalization;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.internal.tasks.core.ITransferList;
import org.eclipse.mylyn.internal.tasks.core.RepositoryModel;
import org.eclipse.mylyn.internal.tasks.core.XmlReaderUtil;
import org.eclipse.mylyn.internal.tasks.core.externalization.SaxTaskListHandler;
import org.eclipse.mylyn.internal.tasks.core.externalization.SaxTaskListWriter;
import org.eclipse.mylyn.tasks.core.IRepositoryManager;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class TaskListExternalizer {
    private static final String ERROR_TASKLIST_READ = "Failed to load Task List";
    private final RepositoryModel repositoryModel;
    private final IRepositoryManager repositoryManager;
    private Document orphanDocument;

    public TaskListExternalizer(RepositoryModel repositoryModel, IRepositoryManager repositoryManager) {
        this.repositoryModel = repositoryModel;
        this.repositoryManager = repositoryManager;
    }

    public void writeTaskList(ITransferList taskList, File outFile) throws CoreException {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (FileOutputStream outStream = new FileOutputStream(outFile);){
                Throwable throwable2 = null;
                Object var7_11 = null;
                try (ZipOutputStream zipOutStream = new ZipOutputStream(outStream);){
                    ZipEntry zipEntry = new ZipEntry("tasklist.xml");
                    zipOutStream.putNextEntry(zipEntry);
                    zipOutStream.setMethod(8);
                    SaxTaskListWriter writer = new SaxTaskListWriter();
                    writer.setOutputStream(zipOutStream);
                    writer.writeTaskListToStream(taskList, this.orphanDocument);
                    zipOutStream.flush();
                    zipOutStream.closeEntry();
                    zipOutStream.finish();
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.mylyn.tasks.core", "Saving Task List failed", (Throwable)e));
        }
    }

    public void readTaskList(ITransferList taskList, File inFile) throws CoreException {
        if (!inFile.exists()) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.mylyn.tasks.core", "Task list file not found \"" + inFile.getAbsolutePath() + "\""));
        }
        if (inFile.length() == 0L) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.mylyn.tasks.core", "Task list file contains no data \"" + inFile.getAbsolutePath() + "\""));
        }
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (InputStream taskListFile = this.openTaskList(inFile);){
                XMLReader reader = XmlReaderUtil.createXmlReader();
                SaxTaskListHandler handler = new SaxTaskListHandler(taskList, this.repositoryModel, this.repositoryManager);
                reader.setContentHandler(handler);
                reader.parse(new InputSource(taskListFile));
                this.orphanDocument = handler.getOrphans();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | SAXException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.mylyn.tasks.core", e.getMessage(), (Throwable)e));
        }
    }

    private InputStream openTaskList(File inputFile) throws CoreException {
        InputStream in = null;
        try {
            if (inputFile.getName().endsWith(".xml.zip")) {
                in = new ZipInputStream(new BufferedInputStream(new FileInputStream(inputFile)));
                ZipEntry entry = ((ZipInputStream)in).getNextEntry();
                while (entry != null) {
                    if ("tasklist.xml".equals(entry.getName())) break;
                    entry = ((ZipInputStream)in).getNextEntry();
                }
                if (entry == null) {
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.mylyn.tasks.core", "Task list file contains no entry for the task list"));
                }
            } else {
                in = new FileInputStream(inputFile);
            }
            return in;
        }
        catch (Exception e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.mylyn.tasks.core", ERROR_TASKLIST_READ, (Throwable)e));
        }
    }
}

