/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.internal.core.refactoring.resource;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.resource.DeleteResourceChange;
import org.eclipse.ltk.internal.core.refactoring.BasicElementLabels;
import org.eclipse.ltk.internal.core.refactoring.Messages;
import org.eclipse.ltk.internal.core.refactoring.RefactoringCoreMessages;
import org.eclipse.ltk.internal.core.refactoring.RefactoringCorePlugin;
import org.eclipse.ltk.internal.core.refactoring.resource.undostates.ResourceUndoState;

public class UndoDeleteResourceChange
extends Change {
    private final ResourceUndoState fResourceState;

    public UndoDeleteResourceChange(ResourceUndoState resourceDescription) {
        this.fResourceState = resourceDescription;
    }

    @Override
    public void initializeValidationData(IProgressMonitor pm) {
    }

    @Override
    public Object getModifiedElement() {
        return null;
    }

    @Override
    public String getName() {
        return Messages.format(RefactoringCoreMessages.UndoDeleteResourceChange_change_name, BasicElementLabels.getResourceName(this.fResourceState.getName()));
    }

    @Override
    public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        if (!this.fResourceState.isValid()) {
            return RefactoringStatus.createFatalErrorStatus(Messages.format(RefactoringCoreMessages.UndoDeleteResourceChange_cannot_restore, BasicElementLabels.getResourceName(this.fResourceState.getName())));
        }
        return new RefactoringStatus();
    }

    @Override
    public Change perform(IProgressMonitor pm) throws CoreException {
        if (this.fResourceState.verifyExistence(true)) {
            String message = Messages.format(RefactoringCoreMessages.UndoDeleteResourceChange_already_exists, BasicElementLabels.getResourceName(this.fResourceState.getName()));
            throw new CoreException((IStatus)new Status(4, RefactoringCorePlugin.getPluginId(), message));
        }
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)pm, (int)2);
        IResource created = this.fResourceState.createResource((IProgressMonitor)subMonitor.newChild(1));
        created.refreshLocal(2, (IProgressMonitor)subMonitor.newChild(1));
        DeleteResourceChange change = new DeleteResourceChange(created.getFullPath(), true, false);
        change.setValidationMethod(3);
        return change;
    }

    public String toString() {
        return Messages.format(RefactoringCoreMessages.UndoDeleteResourceChange_revert_resource, this.fResourceState.getName());
    }
}

