/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.ui.wizards;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.php.internal.debug.ui.Logger;
import org.eclipse.php.internal.debug.ui.PHPDebugUIPlugin;
import org.eclipse.php.internal.debug.ui.wizards.IDebuggerSettingsSectionBuilder;

public class DebuggerSettingsSectionBuildersRegistry {
    private static Map<String, IDebuggerSettingsSectionBuilder> buildersMap = null;
    protected static final String PROP_ID = "id";
    protected static final String PROP_DEBUGGER_SETTINGS_PROVIDER_ID = "phpDebuggerSettingsProviderId";
    protected static final String PROP_BUILDER = "builder";
    public static final String EXTENSION_POINT_ID = PHPDebugUIPlugin.getDefault().getBundle().getSymbolicName() + ".phpDebuggerSettingsSectionBuilders";
    private static DebuggerSettingsSectionBuildersRegistry instance;

    public static final synchronized IDebuggerSettingsSectionBuilder getBuilder(String providerId) {
        Map<String, IDebuggerSettingsSectionBuilder> builders = DebuggerSettingsSectionBuildersRegistry.getBuilders();
        return builders.get(providerId);
    }

    protected static final Map<String, IDebuggerSettingsSectionBuilder> getBuilders() {
        if (buildersMap == null) {
            buildersMap = DebuggerSettingsSectionBuildersRegistry.getDefault().readFromExtensionPoint();
        }
        return buildersMap;
    }

    protected static DebuggerSettingsSectionBuildersRegistry getDefault() {
        if (instance == null) {
            instance = new DebuggerSettingsSectionBuildersRegistry();
        }
        return instance;
    }

    protected Map<String, IDebuggerSettingsSectionBuilder> readFromExtensionPoint() {
        IConfigurationElement[] configurationElements;
        HashMap<String, IDebuggerSettingsSectionBuilder> factories = new HashMap<String, IDebuggerSettingsSectionBuilder>();
        IConfigurationElement[] iConfigurationElementArray = configurationElements = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_POINT_ID);
        int n = configurationElements.length;
        int n2 = 0;
        while (n2 < n) {
            block3: {
                IDebuggerSettingsSectionBuilder builder;
                IConfigurationElement element = iConfigurationElementArray[n2];
                try {
                    builder = (IDebuggerSettingsSectionBuilder)this.createInstance(element, PROP_BUILDER, IDebuggerSettingsSectionBuilder.class);
                }
                catch (CoreException e) {
                    Logger.logException("Could not instantiate debugger settings section builder from extension point data.", e);
                    break block3;
                }
                factories.put(element.getAttribute(PROP_DEBUGGER_SETTINGS_PROVIDER_ID), builder);
            }
            ++n2;
        }
        return factories;
    }

    protected Object createInstance(IConfigurationElement element, String propertyName, Class instanceClass) throws CoreException {
        Object object = element.createExecutableExtension(propertyName);
        if (!instanceClass.isAssignableFrom(object.getClass())) {
            String message = String.format("Invalid typecast for %s", element.getAttribute(propertyName));
            Status status = new Status(4, PHPDebugUIPlugin.getDefault().getBundle().getSymbolicName(), message);
            throw new CoreException((IStatus)status);
        }
        return object;
    }
}

