/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.mpc.core.util;

import java.io.BufferedInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.epp.internal.mpc.core.MarketplaceClientCore;
import org.eclipse.epp.internal.mpc.core.util.Messages;
import org.eclipse.epp.internal.mpc.core.util.TransportFactory;
import org.eclipse.epp.mpc.core.service.ITransport;
import org.eclipse.epp.mpc.core.service.ITransportFactory;
import org.eclipse.epp.mpc.core.service.ServiceUnavailableException;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public class FallbackTransportFactory
implements ITransportFactory {
    private ITransportFactory primaryFactory;
    private ITransportFactory secondaryFactory;
    private FallbackTransport transport;

    @Override
    public synchronized ITransport getTransport() {
        ITransportFactory delegateFactory = this.getFallbackFactory();
        ITransport primaryTransport = this.primaryFactory.getTransport();
        if (delegateFactory == null) {
            return primaryTransport;
        }
        ITransport secondaryTransport = delegateFactory.getTransport();
        if (this.transport == null || this.transport.getPrimaryTransport() != primaryTransport || this.transport.getFallbackTransport() != secondaryTransport) {
            this.transport = new FallbackTransport(primaryTransport, secondaryTransport);
        }
        return this.transport;
    }

    public ITransportFactory getFallbackFactory() {
        ITransportFactory delegateFactory;
        block5: {
            delegateFactory = this.secondaryFactory;
            if (delegateFactory == null) {
                BundleContext bundleContext = FrameworkUtil.getBundle(this.getClass()).getBundleContext();
                try {
                    String disabledTransportsFilter = TransportFactory.computeDisabledTransportsFilter();
                    Collection serviceReferences = bundleContext.getServiceReferences(ITransportFactory.class, "".equals(disabledTransportsFilter) ? null : disabledTransportsFilter);
                    if (serviceReferences.isEmpty()) break block5;
                    for (ServiceReference serviceReference : serviceReferences) {
                        ITransportFactory service = (ITransportFactory)bundleContext.getService(serviceReference);
                        if (service != this && service != this.primaryFactory && !"org.eclipse.epp.mpc.tests.service.MappedTransportFactory".equals(service.getClass().getName())) {
                            delegateFactory = service;
                            break;
                        }
                        bundleContext.ungetService(serviceReference);
                    }
                }
                catch (InvalidSyntaxException invalidSyntaxException) {
                    // empty catch block
                }
            }
        }
        return delegateFactory;
    }

    public ITransportFactory getPrimaryFactory() {
        return this.primaryFactory;
    }

    public void setPrimaryFactory(ITransportFactory primaryFactory) {
        this.primaryFactory = primaryFactory;
    }

    public void bindPrimaryFactory(ITransportFactory factory) {
        this.setPrimaryFactory(factory);
    }

    public void unbindPrimaryFactory(ITransportFactory factory) {
        if (this.primaryFactory == factory) {
            this.setPrimaryFactory(null);
        }
    }

    public ITransportFactory getSecondaryFactory() {
        return this.secondaryFactory;
    }

    public void setSecondaryFactory(ITransportFactory secondaryFactory) {
        this.secondaryFactory = secondaryFactory;
    }

    private static final class FallbackTransport
    implements ITransport {
        private final ITransport primaryTransport;
        private final ITransport fallbackTransport;
        private boolean primaryDisabled = false;
        private final Set<String> reportedProblems = new HashSet<String>();
        private int connectionAttempts;
        private int connectionFailures;

        FallbackTransport(ITransport primaryTransport, ITransport fallbackTransport) {
            this.primaryTransport = primaryTransport;
            this.fallbackTransport = fallbackTransport;
        }

        @Override
        public InputStream stream(URI location, IProgressMonitor monitor) throws FileNotFoundException, ServiceUnavailableException, CoreException {
            InputStream stream;
            ++this.connectionAttempts;
            if (this.connectionAttempts > 10 && (double)this.connectionFailures / (double)this.connectionAttempts > 0.75) {
                MarketplaceClientCore.getLog().log((IStatus)new Status(1, "org.eclipse.epp.mpc.core", NLS.bind((String)Messages.FallbackTransportFactory_disablingTransport, (Object)this.primaryTransport)));
                this.primaryDisabled = true;
            }
            if (this.primaryTransport == null || this.primaryDisabled) {
                return this.fallbackTransport.stream(location, monitor);
            }
            try {
                stream = this.primaryTransport.stream(location, monitor);
                if (stream == null) {
                    throw new NullPointerException();
                }
            }
            catch (FileNotFoundException ex) {
                InputStream fallbackStream = this.primaryFailed(location, monitor, ex);
                if (fallbackStream == null) {
                    throw ex;
                }
                return fallbackStream;
            }
            catch (ServiceUnavailableException ex) {
                InputStream fallbackStream = this.primaryFailed(location, monitor, (Exception)((Object)ex));
                if (fallbackStream == null) {
                    throw ex;
                }
                return fallbackStream;
            }
            catch (CoreException ex) {
                InputStream fallbackStream = this.primaryFailed(location, monitor, (Exception)((Object)ex));
                if (fallbackStream == null) {
                    throw ex;
                }
                return fallbackStream;
            }
            catch (RuntimeException ex) {
                InputStream fallbackStream = this.primaryFailed(location, monitor, ex);
                if (fallbackStream == null) {
                    throw ex;
                }
                return fallbackStream;
            }
            try {
                BufferedInputStream buffered = new BufferedInputStream(stream);
                FallbackTransport.tryBuffer(buffered);
                return buffered;
            }
            catch (IOException ex) {
                InputStream fallbackStream = this.primaryFailed(location, monitor, ex);
                if (fallbackStream == null) {
                    throw new CoreException(MarketplaceClientCore.computeStatus(ex, null));
                }
                return fallbackStream;
            }
        }

        private static void tryBuffer(BufferedInputStream buffered) throws IOException {
            buffered.mark(128);
            try {
                buffered.read(new byte[128]);
            }
            finally {
                buffered.reset();
            }
        }

        private InputStream primaryFailed(URI location, IProgressMonitor monitor, Exception ex) throws FileNotFoundException, ServiceUnavailableException, CoreException {
            block19: {
                ++this.connectionFailures;
                if (this.fallbackTransport != null) {
                    boolean fallbackSucceeded = false;
                    try {
                        BufferedInputStream bufferedInputStream;
                        block18: {
                            Throwable throwable = null;
                            Object var6_8 = null;
                            InputStream fallbackStream = this.fallbackTransport.stream(location, monitor);
                            try {
                                BufferedInputStream buffered = new BufferedInputStream(fallbackStream);
                                FallbackTransport.tryBuffer(buffered);
                                fallbackSucceeded = true;
                                String problemKey = ex.getClass().getName() + ": " + ex.getMessage() + "\n\t" + String.valueOf(ex.getStackTrace()[0]);
                                if (this.reportedProblems.add(problemKey)) {
                                    MarketplaceClientCore.getLog().log(MarketplaceClientCore.computeStatus(ex, NLS.bind((String)Messages.FallbackTransportFactory_fallbackStream, (Object)this.primaryTransport, (Object)this.fallbackTransport)));
                                }
                                bufferedInputStream = buffered;
                                if (fallbackStream == null) break block18;
                            }
                            catch (Throwable throwable2) {
                                try {
                                    try {
                                        if (fallbackStream != null) {
                                            fallbackStream.close();
                                        }
                                        throw throwable2;
                                    }
                                    catch (Throwable throwable3) {
                                        if (throwable == null) {
                                            throwable = throwable3;
                                        } else if (throwable != throwable3) {
                                            throwable.addSuppressed(throwable3);
                                        }
                                        throw throwable;
                                    }
                                }
                                catch (Exception fallbackEx) {
                                    ex.addSuppressed(fallbackEx);
                                    break block19;
                                }
                            }
                            fallbackStream.close();
                        }
                        return bufferedInputStream;
                    }
                    finally {
                        if (!fallbackSucceeded) {
                            --this.connectionFailures;
                        }
                    }
                }
            }
            return null;
        }

        public ITransport getPrimaryTransport() {
            return this.primaryTransport;
        }

        public ITransport getFallbackTransport() {
            return this.fallbackTransport;
        }
    }
}

