/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.ui.internal.utils;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jdt.annotation.Owning;
import org.eclipse.jface.text.IDocument;
import org.eclipse.tm4e.ui.TMUIPlugin;
import org.eclipse.tm4e.ui.internal.utils.ClassHelper;
import org.eclipse.tm4e.ui.internal.utils.ContentTypeInfo;
import org.eclipse.tm4e.ui.internal.utils.DocumentInputStream;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IStorageEditorInput;

public final class ContentTypeHelper {
    public static IContentType[] findContentTypesByFileName(String fileName) {
        return Platform.getContentTypeManager().findContentTypesFor(fileName);
    }

    public static @Nullable ContentTypeInfo findContentTypes(IDocument document) {
        ContentTypeInfo contentTypes = ContentTypeHelper.findContentTypesFromFileBuffers(document);
        if (contentTypes != null) {
            return contentTypes;
        }
        return ContentTypeHelper.findContentTypesFromEditorInput(document);
    }

    public static @Nullable IContentType getContentTypeById(String contentTypeId) {
        return Platform.getContentTypeManager().getContentType(contentTypeId);
    }

    private static @Nullable ContentTypeInfo findContentTypesFromFileBuffers(IDocument document) {
        ITextFileBufferManager bufferManager = FileBuffers.getTextFileBufferManager();
        ITextFileBuffer buffer = bufferManager.getTextFileBuffer(document);
        if (buffer != null) {
            return ContentTypeHelper.getContentTypes(buffer);
        }
        return null;
    }

    private static @Nullable ContentTypeInfo getContentTypes(ITextFileBuffer buffer) {
        try {
            LinkedHashSet<IContentType> contentTypes;
            String fileName;
            block22: {
                Throwable throwable;
                fileName = buffer.getFileStore().getName();
                contentTypes = new LinkedHashSet<IContentType>();
                if (buffer.isDirty() && buffer.getDocument() != null) {
                    throwable = null;
                    Object var4_7 = null;
                    try (DocumentInputStream contents = new DocumentInputStream(buffer.getDocument());){
                        contentTypes.addAll(List.of(Platform.getContentTypeManager().findContentTypesFor((InputStream)contents, fileName)));
                        break block22;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                throwable = null;
                Object var4_9 = null;
                try (InputStream contents = ContentTypeHelper.getContents(buffer);){
                    contentTypes.addAll(List.of(Platform.getContentTypeManager().findContentTypesFor(contents, fileName)));
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                    } else if (throwable != throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    throw throwable;
                }
            }
            IContentType bufferContentType = buffer.getContentType();
            if (bufferContentType != null) {
                contentTypes.add(bufferContentType);
            }
            return new ContentTypeInfo(fileName, (IContentType[])contentTypes.toArray(IContentType[]::new));
        }
        catch (Exception ex) {
            TMUIPlugin.logTrace(ex);
            return null;
        }
    }

    @Owning
    private static InputStream getContents(ITextFileBuffer buffer) throws CoreException {
        IPath path = buffer.getLocation();
        if (path != null) {
            if (path.isAbsolute()) {
                File file = path.toFile();
                if (file.exists()) {
                    try {
                        return new BufferedInputStream(new FileInputStream(file));
                    }
                    catch (FileNotFoundException ex) {
                        TMUIPlugin.logError(ex);
                    }
                }
            } else {
                IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
                IFile file = workspaceRoot.getFile(path);
                if (file.exists() && buffer.isSynchronized()) {
                    return file.getContents();
                }
            }
        }
        return buffer.getFileStore().openInputStream(0, null);
    }

    private static @Nullable ContentTypeInfo findContentTypesFromEditorInput(IDocument document) {
        IEditorInput editorInput = ContentTypeHelper.getEditorInput(document);
        if (editorInput != null && editorInput instanceof IStorageEditorInput) {
            IStorageEditorInput storageInput = (IStorageEditorInput)editorInput;
            try {
                IStorage storage = storageInput.getStorage();
                String fileName = storage.getName();
                Throwable throwable = null;
                Object var6_8 = null;
                try (InputStream input = storage.getContents();){
                    IContentType[] contentTypes = Platform.getContentTypeManager().findContentTypesFor(input, fileName);
                    ContentTypeInfo contentTypeInfo = contentTypes == null ? null : new ContentTypeInfo(fileName, contentTypes);
                    return contentTypeInfo;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception ex) {
                TMUIPlugin.logTrace(ex);
            }
        }
        return null;
    }

    private static @Nullable IEditorInput getEditorInput(IDocument document) {
        block6: {
            try {
                Object[] l;
                ListenerList listeners = (ListenerList)ClassHelper.getFieldValue(document, "fDocumentListeners");
                if (listeners == null) break block6;
                Object[] objectArray = l = listeners.getListeners();
                int n = l.length;
                int n2 = 0;
                while (n2 < n) {
                    Object info = objectArray[n2];
                    try {
                        Object input = ClassHelper.getFieldValue(info, "fElement");
                        if (input instanceof IEditorInput) {
                            IEditorInput editorInput = (IEditorInput)input;
                            return editorInput;
                        }
                    }
                    catch (RuntimeException ex) {
                        TMUIPlugin.logTrace(ex);
                    }
                    ++n2;
                }
            }
            catch (RuntimeException ex) {
                TMUIPlugin.logTrace(ex);
            }
        }
        return null;
    }

    private ContentTypeHelper() {
    }
}

