/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.internal;

import java.nio.charset.Charset;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.resources.IFile;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension4;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServerPlugin;

public final class DocumentUtil {
    private DocumentUtil() {
    }

    public static long getDocumentModificationStamp(@Nullable IDocument document) {
        IFile file;
        if (document instanceof IDocumentExtension4) {
            IDocumentExtension4 ext = (IDocumentExtension4)document;
            return ext.getModificationStamp();
        }
        if (document != null && (file = LSPEclipseUtils.getFile(document)) != null) {
            return file.getModificationStamp();
        }
        return -1L;
    }

    public static Charset getCharset(IDocument document) {
        ITextFileBuffer buffer = LSPEclipseUtils.toBuffer(document);
        if (buffer == null) {
            return Charset.defaultCharset();
        }
        try {
            String charsetName = buffer.getEncoding();
            if (charsetName != null) {
                return Charset.forName(charsetName);
            }
        }
        catch (Exception ex) {
            LanguageServerPlugin.logError(ex);
        }
        return Charset.defaultCharset();
    }
}

